/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class GlobalDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "global";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.SET;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        this.processDefinition(string, context);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public String getReference() {
        return "define global variable";
    }

    @Override
    public boolean isGlobalPhaseAllowed() {
        return true;
    }

    @Override
    public boolean isPreprocessingPhaseAllowed() {
        return false;
    }

    private void processDefinition(String string, PreprocessorContext context) {
        String[] splitted = PreprocessorUtils.splitForEqualChar(string);
        if (splitted.length != 2) {
            throw context.makeException("Can't find expression [" + string + ']', null);
        }
        String name = splitted[0].trim();
        Value newValue = Expression.evalExpression(splitted[1].trim(), context);
        context.setGlobalVariable(name, newValue);
    }
}

