/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;

public class IfDefinedDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "ifdefined";
    }

    @Override
    public String getReference() {
        return "check existence of variable in the current context, it starts //#ifdefined..//#else..//#endif control structure";
    }

    protected boolean postprocessFlag(boolean variableExists) {
        return !variableExists;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.VARNAME;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isDirectiveCanBeProcessed()) {
            boolean variableExists;
            if (string.isEmpty()) {
                throw context.makeException(this.getFullName() + " needs variable name", null);
            }
            state.pushIf(true);
            boolean bl = variableExists = context.findVariableForName(string) != null;
            if (this.postprocessFlag(variableExists)) {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        } else {
            state.pushIf(false);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

