/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;

public class IfDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "if";
    }

    @Override
    public String getReference() {
        return "check flag and start //#if..//#else..//#endif construction";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.BOOLEAN;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isDirectiveCanBeProcessed()) {
            Value expressionResult = Expression.evalExpression(string, context);
            if (expressionResult == null || expressionResult.getType() != ValueType.BOOLEAN) {
                throw context.makeException("Non boolean flag", null);
            }
            state.pushIf(true);
            if (!expressionResult.asBoolean().booleanValue()) {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        } else {
            state.pushIf(false);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

