/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;

public class OutNameDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    public String getName() {
        return "outname";
    }

    @Override
    public String getReference() {
        return "change result file name (works like change 'jcp.dst.name')";
    }

    @Override
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    public AfterDirectiveProcessingBehaviour execute(String string, PreprocessorContext context) {
        Value fileName = Expression.evalExpression(string, context);
        String fileNameAsStr = fileName.toString();
        if (context.isVerbose()) {
            context.logForVerbose("Change result file name to '" + fileNameAsStr + "'");
        }
        context.getPreprocessingState().getRootFileInfo().setDestinationName(fileNameAsStr);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

