/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.DefineDirectiveHandler;
import com.igormaznitsa.jcp.expression.Value;

public class UndefDirectiveHandler
extends DefineDirectiveHandler {
    @Override
    public String getName() {
        return "undef";
    }

    @Override
    public String getReference() {
        return "undefine either local or global variable if it is defined";
    }

    @Override
    protected void process(PreprocessorContext context, String varName, Value value, boolean exists) {
        if (context.isLocalVariable(varName)) {
            context.removeLocalVariable(varName);
        } else if (context.isGlobalVariable(varName)) {
            context.removeGlobalVariable(varName);
        } else {
            throw context.makeException("Attempting to undefine unknown variable '" + value + "'", null);
        }
    }
}

