/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.exceptions;

import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PreprocessorException
extends RuntimeException {
    private static final long serialVersionUID = 2857499664112391862L;
    private final String processingString;
    private final transient FilePositionInfo[] includeStack;

    public PreprocessorException(String message, String processedText, FilePositionInfo[] includeStack, Throwable cause) {
        super(message, cause);
        this.processingString = processedText;
        this.includeStack = includeStack == null ? new FilePositionInfo[]{} : (FilePositionInfo[])includeStack.clone();
    }

    public File getRootFile() {
        if (this.includeStack.length == 0) {
            return null;
        }
        return this.includeStack[this.includeStack.length - 1].getFile();
    }

    public File getProcessingFile() {
        if (this.includeStack.length == 0) {
            return null;
        }
        return this.includeStack[0].getFile();
    }

    public int getStringIndex() {
        if (this.includeStack.length == 0) {
            return -1;
        }
        return this.includeStack[0].getStringIndex() + 1;
    }

    public String getProcessingString() {
        return this.processingString;
    }

    private String convertIncludeStackToString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.includeStack.length; ++i) {
            if (i > 0) {
                result.append("<-");
            }
            result.append(this.includeStack[i].toString());
        }
        return result.toString();
    }

    public FilePositionInfo[] getIncludeChain() {
        return (FilePositionInfo[])this.includeStack.clone();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getMessage()).append(", include stack: ").append(this.convertIncludeStackToString()).append(", source line: ").append(this.processingString);
        return result.toString();
    }

    private static String makeStackView(FilePositionInfo[] list, char fill) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int tab = 5;
        for (int s = 0; s < tab; ++s) {
            builder.append(fill);
        }
        builder.append("{File chain}");
        tab += 5;
        int fileIndex = 1;
        for (int i = list.length - 1; i >= 0; --i) {
            FilePositionInfo cur = list[i];
            builder.append('\n');
            for (int s = 0; s < tab; ++s) {
                builder.append(fill);
            }
            builder.append("\u2514>");
            builder.append(fileIndex++).append(". ");
            builder.append(cur.getFile().getName()).append(':').append(cur.getStringIndex());
            tab += 3;
        }
        return builder.toString();
    }

    public static PreprocessorException extractPreprocessorException(Throwable thr) {
        if (thr == null) {
            return null;
        }
        Throwable result = thr;
        do {
            if (!(result instanceof PreprocessorException)) continue;
            return (PreprocessorException)result;
        } while ((result = result.getCause()) != null);
        return null;
    }

    public static String referenceAsString(char fillChar, Throwable thr) {
        if (thr == null) {
            return "";
        }
        StringWriter buffer = new StringWriter(1024);
        PrintWriter out = new PrintWriter(buffer);
        PreprocessorException pp = PreprocessorException.extractPreprocessorException(thr);
        if (pp == null) {
            out.println(thr.getMessage());
            thr.printStackTrace(out);
        } else {
            out.println(pp.getMessage());
            out.println(PreprocessorException.makeStackView(pp.getIncludeChain(), fillChar));
            if (pp.getCause() != null) {
                pp.getCause().printStackTrace(out);
            }
        }
        return buffer.toString();
    }
}

