/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionParser;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.ExpressionTreeElement;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.Variable;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.functions.FunctionDefinedByUser;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Expression {
    private static final Class<?>[] OPERATOR_SIGNATURE_1 = new Class[]{Value.class};
    private static final Class<?>[] OPERATOR_SIGNATURE_2 = new Class[]{Value.class, Value.class};
    private final PreprocessorContext context;
    private final ExpressionTree expressionTree;

    public Value eval() {
        return this.eval(null);
    }

    public static Value evalExpression(String expression, PreprocessorContext context) {
        try {
            ExpressionTree tree = ExpressionParser.getInstance().parse(expression, context);
            return Expression.evalTree(tree, context);
        }
        catch (IOException unexpected) {
            throw context.makeException("[Expression]Wrong expression format detected [" + expression + ']', unexpected);
        }
    }

    public static Value evalTree(ExpressionTree tree, PreprocessorContext context) {
        Expression exp = new Expression(context, tree);
        return exp.eval(context == null ? null : context.getPreprocessingState());
    }

    private Expression(PreprocessorContext context, ExpressionTree tree) {
        if (tree == null) {
            throw context.makeException("[Expression]The expression tree is null", null);
        }
        this.context = context;
        this.expressionTree = tree;
    }

    private ExpressionTreeElement evalFunction(ExpressionTreeElement functionElement, PreprocessingState state) {
        int i;
        String sources;
        FilePositionInfo[] stack;
        AbstractFunction function = (AbstractFunction)functionElement.getItem();
        int arity = function.getArity();
        Value[] arguments = new Value[arity];
        Class[] methodArguments = new Class[arity + 1];
        methodArguments[0] = PreprocessorContext.class;
        if (state == null) {
            stack = PreprocessingState.EMPTY_STACK;
            sources = "";
        } else {
            stack = state.makeIncludeStack();
            sources = state.getLastReadString();
        }
        StringBuilder signature = new StringBuilder("execute");
        for (i = 1; i <= arity; ++i) {
            methodArguments[i] = Value.class;
        }
        for (i = 0; i < arity; ++i) {
            ExpressionTreeElement item = this.calculateTreeElement(functionElement.getChildForIndex(i), state);
            if (item == null) {
                throw this.context.makeException("[Expression]There is not needed argument for the '" + function.getName() + "' function", null);
            }
            ExpressionItem expressionItem = item.getItem();
            if (!(expressionItem instanceof Value)) {
                throw this.context.makeException("[Expression]Wrong argument type detected for the '" + function.getName() + "' function", null);
            }
            arguments[i] = (Value)expressionItem;
        }
        ValueType[][] allowedSignatures = function.getAllowedArgumentTypes();
        ValueType[] allowed = null;
        for (ValueType[] current : allowedSignatures) {
            boolean allCompatible = true;
            int thatIndex = 0;
            for (ValueType type : current) {
                if (!type.isCompatible(arguments[thatIndex].getType())) {
                    allCompatible = false;
                    break;
                }
                ++thatIndex;
            }
            if (!allCompatible) continue;
            for (ValueType type : allowed = current) {
                signature.append(type.getSignature());
            }
            break;
        }
        if (allowed == null) {
            throw this.context.makeException("[Expression]Unsupported argument detected for '" + function.getName() + '\'', null);
        }
        if (function instanceof FunctionDefinedByUser) {
            FunctionDefinedByUser functionDefinedByUser = (FunctionDefinedByUser)function;
            try {
                return new ExpressionTreeElement(functionDefinedByUser.execute(this.context, arguments), stack, sources);
            }
            catch (Exception unexpected) {
                throw this.context.makeException("[Expression]Unexpected exception during a user function processing", unexpected);
            }
        }
        try {
            Method method = function.getClass().getMethod(signature.toString(), methodArguments);
            Object[] callArgs = new Object[arity + 1];
            callArgs[0] = this.context;
            System.arraycopy(arguments, 0, callArgs, 1, arity);
            Value result = (Value)method.invoke((Object)function, callArgs);
            if (!result.getType().isCompatible(function.getResultType())) {
                throw this.context.makeException("[Expression]Unsupported function result detected [" + result.getType().getSignature() + ']', null);
            }
            return new ExpressionTreeElement(result, stack, sources);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.context.makeException("[Expression]Can't find a function method to process data [" + signature.toString() + ']', noSuchMethodException);
        }
        catch (Exception exception) {
            throw this.context.makeException("[Expression]Can't execute a function method to process data [" + function.getClass().getName() + '.' + signature.toString() + ']', exception);
        }
    }

    private ExpressionTreeElement evalOperator(ExpressionTreeElement operatorElement, PreprocessingState state) {
        String sources;
        FilePositionInfo[] stack;
        AbstractOperator operator = (AbstractOperator)operatorElement.getItem();
        int arity = operator.getArity();
        Object[] arguments = new Value[arity];
        Class<?>[] methodArguments = arity == 1 ? OPERATOR_SIGNATURE_1 : OPERATOR_SIGNATURE_2;
        StringBuilder signatureNormal = new StringBuilder("execute");
        StringBuilder signatureAnyLeft = new StringBuilder("execute");
        StringBuilder signatureAnyRight = new StringBuilder("execute");
        if (state == null) {
            stack = PreprocessingState.EMPTY_STACK;
            sources = "";
        } else {
            stack = state.makeIncludeStack();
            sources = state.getLastReadString();
        }
        for (int i = 0; i < arity; ++i) {
            Object[] arg = operatorElement.getChildForIndex(i);
            if (arg == null) {
                throw this.context.makeException("[Expression]There is not needed argument for the operator [" + operator.getKeyword() + ']', null);
            }
            ExpressionTreeElement currentElement = this.calculateTreeElement((ExpressionTreeElement)arg, state);
            ExpressionItem item = currentElement.getItem();
            if (!(item instanceof Value)) {
                throw this.context.makeException("[Expression]Non-value detected for the '" + operator.getKeyword() + "' operator", null);
            }
            arguments[i] = (Value)item;
        }
        int argIndex = 0;
        for (Value value : arguments) {
            String typeSignature = value.getType().getSignature();
            signatureNormal.append(typeSignature);
            if (argIndex == 0) {
                signatureAnyLeft.append(ValueType.ANY.getSignature());
            } else {
                signatureAnyLeft.append(typeSignature);
            }
            if (argIndex == 1) {
                signatureAnyRight.append(ValueType.ANY.getSignature());
            } else {
                signatureAnyRight.append(typeSignature);
            }
            ++argIndex;
        }
        Method executeMehod = null;
        try {
            executeMehod = operator.getClass().getMethod(signatureNormal.toString(), methodArguments);
        }
        catch (NoSuchMethodException ex) {
            try {
                executeMehod = operator.getClass().getMethod(signatureAnyLeft.toString(), methodArguments);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    executeMehod = operator.getClass().getMethod(signatureAnyRight.toString(), methodArguments);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        if (executeMehod == null) {
            throw this.context.makeException("[Expression]Unsupported arguments detected for operator '" + operator.getKeyword() + "' " + Arrays.toString(arguments), null);
        }
        try {
            return new ExpressionTreeElement((Value)executeMehod.invoke((Object)operator, arguments), stack, sources);
        }
        catch (ArithmeticException arithEx) {
            throw arithEx;
        }
        catch (InvocationTargetException ex) {
            Throwable thr = ex.getTargetException();
            if (thr instanceof ArithmeticException) {
                throw (ArithmeticException)thr;
            }
            throw new RuntimeException("Invocation exception during '" + operator.getKeyword() + "' processing", thr);
        }
        catch (Exception unexpected) {
            throw this.context.makeException("[Exception]Exception during '" + operator.getKeyword() + "' processing", unexpected);
        }
    }

    private ExpressionTreeElement calculateTreeElement(ExpressionTreeElement element, PreprocessingState state) {
        ExpressionTreeElement treeElement = element;
        switch (element.getItem().getExpressionItemType()) {
            case VARIABLE: {
                PreprocessorUtils.assertNotNull("[Expression]Variable can't be used without context [" + element.getItem().toString() + ']', this.context);
                Variable var = (Variable)element.getItem();
                String name = var.getName();
                Value value = this.context.findVariableForName(name);
                if (value == null) {
                    throw new RuntimeException("Unknown variable [" + name + ']');
                }
                treeElement = new ExpressionTreeElement(value, state.makeIncludeStack(), state.getLastReadString());
                break;
            }
            case OPERATOR: {
                treeElement = this.evalOperator(element, state);
                break;
            }
            case FUNCTION: {
                treeElement = this.evalFunction(element, state);
            }
        }
        return treeElement;
    }

    private Value eval(PreprocessingState state) {
        if (this.expressionTree.isEmpty()) {
            throw this.context.makeException("[Expression]The expression is empty", null);
        }
        ExpressionTreeElement result = this.calculateTreeElement(this.expressionTree.getRoot(), state);
        ExpressionItem resultItem = result.getItem();
        if (resultItem == null) {
            throw this.context.makeException("[Expression]Expression doesn't have result", null);
        }
        if (resultItem instanceof Value) {
            return (Value)resultItem;
        }
        throw this.context.makeException("[Expression]The expression returns non-value result [" + resultItem + ']', null);
    }
}

