/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.ExpressionTreeElement;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.Variable;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.functions.FunctionDefinedByUser;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import com.igormaznitsa.jcp.expression.operators.OperatorSUB;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;

public final class ExpressionParser {
    private static final ExpressionParser INSTANCE = new ExpressionParser();
    private static final OperatorSUB OPERATOR_SUB = AbstractOperator.findForClass(OperatorSUB.class);

    public static ExpressionParser getInstance() {
        return INSTANCE;
    }

    public ExpressionTree parse(String expressionStr, PreprocessorContext context) throws IOException {
        PreprocessingState state;
        PreprocessorUtils.assertNotNull("Expression is null", expressionStr);
        PushbackReader reader = new PushbackReader(new StringReader(expressionStr));
        ExpressionTree result = context == null ? new ExpressionTree() : ((state = context.getPreprocessingState()) == null ? new ExpressionTree() : new ExpressionTree(state.makeIncludeStack(), state.getLastReadString()));
        if (this.readExpression(reader, result, context, false, false) != null) {
            String text = "Unexpected result during parsing [" + expressionStr + ']';
            throw context == null ? new IllegalStateException(text) : context.makeException(text, null);
        }
        result.postProcess();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ExpressionItem readExpression(PushbackReader reader, ExpressionTree tree, PreprocessorContext context, boolean insideBracket, boolean argument) throws IOException {
        String sourceLine;
        FilePositionInfo[] stack;
        boolean working = true;
        ExpressionItem result = null;
        if (context == null) {
            stack = PreprocessingState.EMPTY_STACK;
            sourceLine = "";
        } else {
            PreprocessingState state = context.getPreprocessingState();
            stack = state == null ? null : state.makeIncludeStack();
            sourceLine = state == null ? null : state.getLastReadString();
        }
        ExpressionItem prev = null;
        while (working) {
            ExpressionItem nextItem;
            block17: {
                block19: {
                    String text;
                    block20: {
                        block18: {
                            nextItem = this.nextItem(reader, context);
                            if (nextItem != null) break block18;
                            working = false;
                            result = null;
                            break block17;
                        }
                        if (nextItem.getExpressionItemType() != null) break block19;
                        if (nextItem != SpecialItem.BRACKET_CLOSING) break block20;
                        if (insideBracket) {
                            working = false;
                            result = nextItem;
                            break block17;
                        } else if (argument) {
                            working = false;
                            result = nextItem;
                            break block17;
                        } else {
                            RuntimeException runtimeException;
                            text = "Detected alone closing bracket";
                            if (context == null) {
                                runtimeException = new IllegalStateException("Detected alone closing bracket");
                                throw runtimeException;
                            }
                            runtimeException = context.makeException("Detected alone closing bracket", null);
                            throw runtimeException;
                        }
                    }
                    if (nextItem == SpecialItem.BRACKET_OPENING) {
                        if (prev != null && prev.getExpressionItemType() == ExpressionItemType.VARIABLE) {
                            RuntimeException runtimeException;
                            text = "Unknown function detected [" + prev.toString() + ']';
                            if (context == null) {
                                runtimeException = new IllegalStateException(text);
                                throw runtimeException;
                            }
                            runtimeException = context.makeException(text, null);
                            throw runtimeException;
                        }
                        ExpressionTree subExpression = new ExpressionTree(stack, sourceLine);
                        if (SpecialItem.BRACKET_CLOSING != this.readExpression(reader, subExpression, context, true, false)) {
                            RuntimeException runtimeException;
                            String text2 = "Detected unclosed bracket";
                            if (context == null) {
                                runtimeException = new IllegalStateException("Detected unclosed bracket");
                                throw runtimeException;
                            }
                            runtimeException = context.makeException("Detected unclosed bracket", null);
                            throw runtimeException;
                        }
                        tree.addTree(subExpression);
                        break block17;
                    } else if (nextItem == SpecialItem.COMMA) {
                        return nextItem;
                    }
                    break block17;
                }
                if (nextItem.getExpressionItemType() == ExpressionItemType.FUNCTION) {
                    AbstractFunction function = (AbstractFunction)nextItem;
                    ExpressionTree functionTree = this.readFunction(function, reader, context, stack, sourceLine);
                    tree.addTree(functionTree);
                } else {
                    tree.addItem(nextItem);
                }
            }
            prev = nextItem;
        }
        return result;
    }

    private ExpressionTree readFunction(AbstractFunction function, PushbackReader reader, PreprocessorContext context, FilePositionInfo[] includeStack, String sources) throws IOException {
        ExpressionItem expectedBracket = this.nextItem(reader, context);
        if (expectedBracket == null) {
            throw context.makeException("Detected function without params [" + function.getName() + ']', null);
        }
        int arity = function.getArity();
        ExpressionTree functionTree = null;
        if (arity == 0) {
            ExpressionTree subExpression = new ExpressionTree(includeStack, sources);
            ExpressionItem lastItem = this.readFunctionArgument(reader, subExpression, context, includeStack, sources);
            if (SpecialItem.BRACKET_CLOSING != lastItem) {
                throw context.makeException("There is not closing bracket for function [" + function.getName() + ']', null);
            }
            if (subExpression.getRoot() != null) {
                throw context.makeException("The function '" + function.getName() + "' doesn't need arguments", null);
            }
            functionTree = new ExpressionTree(includeStack, sources);
            functionTree.addItem(function);
        } else {
            ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>(arity);
            for (int i = 0; i < function.getArity(); ++i) {
                ExpressionTree subExpression = new ExpressionTree(includeStack, sources);
                ExpressionItem lastItem = this.readFunctionArgument(reader, subExpression, context, includeStack, sources);
                if (SpecialItem.BRACKET_CLOSING == lastItem) {
                    arguments.add(subExpression);
                    break;
                }
                if (SpecialItem.COMMA != lastItem) {
                    throw context.makeException("Wrong argument for function [" + function.getName() + ']', null);
                }
                arguments.add(subExpression);
            }
            functionTree = new ExpressionTree(includeStack, sources);
            functionTree.addItem(function);
            ExpressionTreeElement functionTreeElement = functionTree.getRoot();
            if (arguments.size() != functionTreeElement.getArity()) {
                throw context.makeException("Wrong argument number detected '" + function.getName() + "', must be " + function.getArity() + " argument(s)", null);
            }
            functionTreeElement.fillArguments(arguments);
        }
        return functionTree;
    }

    ExpressionItem readFunctionArgument(PushbackReader reader, ExpressionTree tree, PreprocessorContext context, FilePositionInfo[] callStack, String source) throws IOException {
        boolean working = true;
        ExpressionItem result = null;
        while (working) {
            ExpressionItem nextItem = this.nextItem(reader, context);
            if (nextItem == null) {
                throw context.makeException("Non-closed function detected", null);
            }
            if (SpecialItem.COMMA == nextItem) {
                result = nextItem;
                working = false;
                continue;
            }
            if (SpecialItem.BRACKET_OPENING == nextItem) {
                ExpressionTree subExpression = new ExpressionTree(callStack, source);
                if (SpecialItem.BRACKET_CLOSING != this.readExpression(reader, subExpression, context, true, false)) {
                    throw context.makeException("Non-closed bracket inside a function argument detected", null);
                }
                tree.addTree(subExpression);
                continue;
            }
            if (SpecialItem.BRACKET_CLOSING == nextItem) {
                result = nextItem;
                working = false;
                continue;
            }
            if (nextItem.getExpressionItemType() == ExpressionItemType.FUNCTION) {
                AbstractFunction function = (AbstractFunction)nextItem;
                ExpressionTree functionTree = this.readFunction(function, reader, context, callStack, source);
                tree.addTree(functionTree);
                continue;
            }
            tree.addItem(nextItem);
        }
        return result;
    }

    private static boolean isDelimiterOrOperatorChar(char chr) {
        return ExpressionParser.isDelimiter(chr) || ExpressionParser.isOperatorChar(chr);
    }

    private static boolean isDelimiter(char chr) {
        switch (chr) {
            case '(': 
            case ')': 
            case ',': {
                return true;
            }
        }
        return false;
    }

    private static boolean isOperatorChar(char chr) {
        switch (chr) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    ExpressionItem nextItem(PushbackReader reader, PreprocessorContext context) throws IOException {
        PreprocessorUtils.assertNotNull("Reader is null", reader);
        ParserState state = ParserState.WAIT;
        StringBuilder builder = new StringBuilder(12);
        boolean found = false;
        while (!found) {
            int data = reader.read();
            if (data < 0) {
                if (state == ParserState.WAIT) break;
                found = true;
                break;
            }
            char chr = (char)data;
            block0 : switch (state) {
                case WAIT: {
                    if (Character.isWhitespace(chr)) break;
                    if (chr == ',') {
                        return SpecialItem.COMMA;
                    }
                    if (chr == '(') {
                        return SpecialItem.BRACKET_OPENING;
                    }
                    if (chr == ')') {
                        return SpecialItem.BRACKET_CLOSING;
                    }
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        if (chr == '0') {
                            state = ParserState.HEX_NUMBER;
                            break;
                        }
                        state = ParserState.NUMBER;
                        break;
                    }
                    if (chr == '.') {
                        builder.append('.');
                        state = ParserState.FLOAT_NUMBER;
                        break;
                    }
                    if (Character.isLetter(chr) || chr == '$' || chr == '_') {
                        builder.append(chr);
                        state = ParserState.VALUE_OR_FUNCTION;
                        break;
                    }
                    if (chr == '\"') {
                        state = ParserState.STRING;
                        break;
                    }
                    if (ExpressionParser.isOperatorChar(chr)) {
                        builder.append(chr);
                        state = ParserState.OPERATOR;
                        break;
                    }
                    throw context.makeException("Unsupported token character detected '" + chr + '\'', null);
                }
                case OPERATOR: {
                    if (!ExpressionParser.isOperatorChar(chr) || ExpressionParser.isDelimiter(chr)) {
                        reader.unread(data);
                        found = true;
                        break;
                    }
                    builder.append(chr);
                    break;
                }
                case FLOAT_NUMBER: {
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        break;
                    }
                    found = true;
                    reader.unread(data);
                    break;
                }
                case HEX_NUMBER: {
                    if (builder.length() == 1) {
                        if (chr == 'X' || chr == 'x') {
                            builder.append(chr);
                            break;
                        }
                        if (chr == '.') {
                            builder.append(chr);
                            state = ParserState.FLOAT_NUMBER;
                            break;
                        }
                        if (Character.isDigit(chr)) {
                            state = ParserState.NUMBER;
                            break;
                        }
                        state = ParserState.NUMBER;
                        found = true;
                        reader.unread(data);
                        break;
                    }
                    if (Character.isDigit(chr) || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F') {
                        builder.append(chr);
                        break;
                    }
                    found = true;
                    reader.unread(data);
                    break;
                }
                case NUMBER: {
                    if (Character.isDigit(chr)) {
                        builder.append(chr);
                        break;
                    }
                    if (chr == '.') {
                        builder.append(chr);
                        state = ParserState.FLOAT_NUMBER;
                        break;
                    }
                    reader.unread(data);
                    found = true;
                    break;
                }
                case VALUE_OR_FUNCTION: {
                    if (Character.isWhitespace(chr) || ExpressionParser.isDelimiterOrOperatorChar(chr)) {
                        reader.unread(data);
                        found = true;
                        break;
                    }
                    builder.append(chr);
                    break;
                }
                case SPECIAL_CHAR: {
                    switch (chr) {
                        case 'n': {
                            builder.append('\n');
                            break;
                        }
                        case 't': {
                            builder.append('\t');
                            break;
                        }
                        case 'b': {
                            builder.append('\b');
                            break;
                        }
                        case 'f': {
                            builder.append('\f');
                            break;
                        }
                        case 'r': {
                            builder.append('\r');
                            break;
                        }
                        case '\\': {
                            builder.append('\\');
                            break;
                        }
                        case '\"': {
                            builder.append('\"');
                            break;
                        }
                        case '\'': {
                            builder.append('\'');
                            break;
                        }
                        default: {
                            throw context.makeException("Unsupported special char detected '\\" + chr + '\'', null);
                        }
                    }
                    state = ParserState.STRING;
                    break;
                }
                case STRING: {
                    switch (chr) {
                        case '\"': {
                            found = true;
                            break block0;
                        }
                        case '\\': {
                            state = ParserState.SPECIAL_CHAR;
                            break block0;
                        }
                    }
                    builder.append(chr);
                    break;
                }
                default: {
                    throw new Error("Unsupported parser state [" + state.name() + ']');
                }
            }
        }
        if (!found) {
            switch (state) {
                case SPECIAL_CHAR: 
                case STRING: {
                    throw context.makeException("Unclosed string has been detected", null);
                }
            }
            return null;
        }
        ExpressionItem result = null;
        switch (state) {
            case FLOAT_NUMBER: {
                result = Value.valueOf(Float.valueOf(Float.parseFloat(builder.toString())));
                break;
            }
            case HEX_NUMBER: {
                String text = builder.toString();
                if ("0".equals(text)) {
                    result = Value.INT_ZERO;
                    break;
                }
                String str = PreprocessorUtils.extractTail("0x", text);
                result = Value.valueOf(Long.parseLong(str, 16));
                break;
            }
            case NUMBER: {
                result = Value.valueOf(Long.parseLong(builder.toString()));
                break;
            }
            case OPERATOR: {
                String operatorLC = builder.toString().toLowerCase(Locale.ENGLISH);
                for (AbstractOperator operator : AbstractOperator.ALL_OPERATORS) {
                    if (!operator.getKeyword().equals(operatorLC)) continue;
                    result = operator;
                    break;
                }
                if (result != null) break;
                throw context.makeException("Unknown operator detected '" + operatorLC + '\'', null);
            }
            case STRING: {
                result = Value.valueOf(builder.toString());
                break;
            }
            case VALUE_OR_FUNCTION: {
                String str = builder.toString().toLowerCase();
                if (str.charAt(0) == '$') {
                    PreprocessorUtils.assertNotNull("There is not a preprocessor context to define a user function [" + str + ']', context);
                    PreprocessorExtension extension = context.getPreprocessorExtension();
                    if (extension == null) {
                        throw context.makeException("There is not any defined preprocessor extension to get data about user functions [" + str + ']', null);
                    }
                    String userFunctionName = PreprocessorUtils.extractTail("$", str);
                    result = new FunctionDefinedByUser(userFunctionName, extension.getUserFunctionArity(userFunctionName), context);
                    break;
                }
                if ("true".equals(str)) {
                    result = Value.BOOLEAN_TRUE;
                    break;
                }
                if ("false".equals(str)) {
                    result = Value.BOOLEAN_FALSE;
                    break;
                }
                AbstractFunction function = AbstractFunction.findForName(str);
                if (function == null) {
                    result = new Variable(str);
                    break;
                }
                result = function;
                break;
            }
            default: {
                throw new Error("Unsupported final parser state detected [" + state.name() + ']');
            }
        }
        return result;
    }

    public static enum SpecialItem implements ExpressionItem
    {
        BRACKET_OPENING('('),
        BRACKET_CLOSING(')'),
        COMMA(',');

        private final char chr;

        private SpecialItem(char chr) {
            this.chr = chr;
        }

        @Override
        public ExpressionItemPriority getExpressionItemPriority() {
            return null;
        }

        @Override
        public ExpressionItemType getExpressionItemType() {
            return null;
        }
    }

    private static enum ParserState {
        WAIT,
        NUMBER,
        HEX_NUMBER,
        FLOAT_NUMBER,
        STRING,
        SPECIAL_CHAR,
        VALUE_OR_FUNCTION,
        OPERATOR;

    }
}

