/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionTreeElement;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public class ExpressionTree {
    private ExpressionTreeElement last;
    private final FilePositionInfo[] includeStack;
    private final String sources;

    public ExpressionTree() {
        this(null, null);
    }

    public ExpressionTree(FilePositionInfo[] callStack, String sources) {
        this.includeStack = callStack == null ? PreprocessingState.EMPTY_STACK : callStack;
        this.sources = sources == null ? "" : sources;
    }

    public boolean isEmpty() {
        return this.last == null;
    }

    public void addItem(ExpressionItem item) {
        if (item == null) {
            throw new PreprocessorException("[Expression]Item is null", this.sources, this.includeStack, null);
        }
        this.last = this.last == null ? new ExpressionTreeElement(item, this.includeStack, this.sources) : this.last.addTreeElement(new ExpressionTreeElement(item, this.includeStack, this.sources));
    }

    public void addTree(ExpressionTree tree) {
        PreprocessorUtils.assertNotNull("Tree is null", tree);
        if (this.last == null) {
            ExpressionTreeElement thatTreeRoot = tree.getRoot();
            if (thatTreeRoot != null) {
                this.last = thatTreeRoot;
                this.last.makeMaxPriority();
            }
        } else {
            this.last = this.last.addSubTree(tree);
        }
    }

    public ExpressionTreeElement getRoot() {
        if (this.last == null) {
            return null;
        }
        ExpressionTreeElement element = this.last;
        ExpressionTreeElement next;
        while ((next = element.getParent()) != null) {
            element = next;
        }
        return element;
    }

    public void postProcess() {
        ExpressionTreeElement root = this.getRoot();
        if (root != null) {
            root.postProcess();
        }
    }
}

