/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.FunctionABS;
import com.igormaznitsa.jcp.expression.functions.FunctionEVALFILE;
import com.igormaznitsa.jcp.expression.functions.FunctionISSUBSTR;
import com.igormaznitsa.jcp.expression.functions.FunctionROUND;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2CSV;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2INT;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JAVA;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JS;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JSON;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2WEB;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2XML;
import com.igormaznitsa.jcp.expression.functions.FunctionSTRLEN;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_ATTR;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_GET;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_LIST;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_NAME;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_OPEN;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_ROOT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_SIZE;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_TEXT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_XELEMENT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_XLIST;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractFunction
implements ExpressionItem {
    public static final String EXECUTION_PREFIX = "execute";
    public static final AbstractFunction[] ALL_FUNCTIONS = new AbstractFunction[]{new FunctionABS(), new FunctionROUND(), new FunctionSTR2INT(), new FunctionSTR2WEB(), new FunctionSTR2CSV(), new FunctionSTR2JS(), new FunctionSTR2JSON(), new FunctionSTR2XML(), new FunctionSTR2JAVA(), new FunctionSTRLEN(), new FunctionISSUBSTR(), new FunctionEVALFILE(), new FunctionXML_GET(), new FunctionXML_SIZE(), new FunctionXML_ATTR(), new FunctionXML_ROOT(), new FunctionXML_NAME(), new FunctionXML_LIST(), new FunctionXML_TEXT(), new FunctionXML_OPEN(), new FunctionXML_XLIST(), new FunctionXML_XELEMENT()};
    protected static final AtomicLong UID_COUNTER = new AtomicLong(1L);

    public static <E extends AbstractFunction> E findForClass(Class<E> functionClass) {
        AbstractFunction result = null;
        for (AbstractFunction function : ALL_FUNCTIONS) {
            if (function.getClass() != functionClass) continue;
            result = (AbstractFunction)functionClass.cast(function);
            break;
        }
        return (E)result;
    }

    public static AbstractFunction findForName(String str) {
        AbstractFunction result = null;
        for (AbstractFunction func : ALL_FUNCTIONS) {
            if (!func.getName().equals(str)) continue;
            result = func;
            break;
        }
        return result;
    }

    public abstract String getName();

    public abstract String getReference();

    public abstract int getArity();

    public abstract ValueType[][] getAllowedArgumentTypes();

    public abstract ValueType getResultType();

    @Override
    public ExpressionItemPriority getExpressionItemPriority() {
        return ExpressionItemPriority.FUNCTION;
    }

    @Override
    public ExpressionItemType getExpressionItemType() {
        return ExpressionItemType.FUNCTION;
    }

    public String toString() {
        return "FUNCTION: " + this.getName();
    }
}

