/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;

public final class FunctionABS
extends AbstractFunction {
    private static final ValueType[][] ARGUMENT_TYPES = new ValueType[][]{{ValueType.INT}, {ValueType.FLOAT}};

    @Override
    public String getName() {
        return "abs";
    }

    public Value executeInt(PreprocessorContext context, Value value) {
        return Value.valueOf(Math.abs(value.asLong()));
    }

    public Value executeFloat(PreprocessorContext context, Value value) {
        return Value.valueOf(Float.valueOf(Math.abs(value.asFloat().floatValue())));
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARGUMENT_TYPES;
    }

    @Override
    public String getReference() {
        return "get absolute value of numeric value";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.ANY;
    }
}

