/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;

public final class FunctionDefinedByUser
extends AbstractFunction {
    private final String name;
    private final int argsNumber;
    private final ValueType[][] argTypes;

    public FunctionDefinedByUser(String name, int argsNumber, PreprocessorContext context) {
        PreprocessorUtils.assertNotNull("Name is null", name);
        PreprocessorUtils.assertNotNull("Context is null", context);
        if (argsNumber < 0) {
            throw context.makeException("Unexpected argument number [" + argsNumber + ']', null);
        }
        this.name = name;
        this.argsNumber = argsNumber;
        ValueType[] types = new ValueType[argsNumber];
        for (int li = 0; li < argsNumber; ++li) {
            types[li] = ValueType.ANY;
        }
        this.argTypes = new ValueType[][]{types};
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getArity() {
        return this.argsNumber;
    }

    public Value execute(PreprocessorContext context, Value[] values) {
        return context.getPreprocessorExtension().processUserFunction(this.name, values);
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return this.argTypes;
    }

    @Override
    public String getReference() {
        return "it's a user defined function";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.ANY;
    }
}

