/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class FunctionEVALFILE
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    public String getName() {
        return "evalfile";
    }

    @Override
    public String getReference() {
        return "load and preprocess file and return text result as string";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }

    public Value executeStr(PreprocessorContext context, Value strfilePath) {
        File theFile;
        PreprocessorContext clonedContext = new PreprocessorContext(context);
        clonedContext.setFileOutputDisabled(true);
        clonedContext.setKeepLines(false);
        clonedContext.setClearDestinationDirBefore(false);
        clonedContext.setRemoveComments(true);
        clonedContext.setCareForLastNextLine(true);
        String filePath = strfilePath.asString();
        try {
            theFile = context.getSourceFile(filePath);
        }
        catch (IOException ex) {
            throw context.makeException("Can't get get source file '" + filePath + '\'', null);
        }
        if (theFile == null) {
            throw context.makeException("Can't find any file for path '" + filePath + "' in defined source folders", null);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Eval file '" + theFile + '\'');
        }
        try {
            FileInfoContainer fileContainer = new FileInfoContainer(theFile, theFile.getName(), false);
            PreprocessingState state = fileContainer.preprocessFile(null, clonedContext);
            StringWriter strWriter = new StringWriter(1024);
            state.writePrinterBuffers(strWriter);
            IOUtils.closeQuietly(strWriter);
            return Value.valueOf(strWriter.toString());
        }
        catch (Exception ex) {
            throw context.makeException("Unexpected exception", ex);
        }
    }
}

