/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractStrConverter;
import hidden.jcp.org.apache.commons.lang3.CharUtils;
import hidden.jcp.org.apache.commons.lang3.StringEscapeUtils;

public final class FunctionSTR2WEB
extends AbstractStrConverter {
    @Override
    public String getName() {
        return "str2web";
    }

    @Override
    public Value executeStr(PreprocessorContext context, Value value) {
        String escaped = StringEscapeUtils.escapeHtml3(value.asString());
        StringBuilder result = new StringBuilder(escaped.length() * 2);
        for (int i = 0; i < escaped.length(); ++i) {
            char ch = escaped.charAt(i);
            if (CharUtils.isAscii(ch)) {
                result.append(ch);
                continue;
            }
            result.append("&#").append(Integer.toString(Character.codePointAt(escaped, i))).append(';');
        }
        return Value.valueOf(result.toString());
    }

    @Override
    public String getReference() {
        return "escape string for HTML3";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

