/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXMLFunction
extends AbstractFunction {
    public static String makeElementListId(Element parentName, String elementName) {
        return AbstractXMLFunction.buildPathForElement(parentName) + "_#list_" + elementName;
    }

    public static String makeDocumentId(String fileName) {
        return "xmlDocument_" + fileName;
    }

    public static String makeDocumentRootId(String documentId) {
        return documentId + "_#root";
    }

    public static String makeElementId(String elementListId, int elementIndex) {
        return elementListId + '_' + elementIndex;
    }

    public static String makeXPathListId(String documentId, String xpath) {
        return documentId + "_#xpath_" + xpath;
    }

    public static String makeXPathElementId(String documentId, String xpath) {
        return documentId + "_#xpathelement_" + xpath;
    }

    public String getAttribute(PreprocessorContext context, String elementId, String attributeName) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementId);
        if (container == null) {
            throw context.makeException("Can't find any active element with the '" + elementId + "' id", null);
        }
        try {
            return ((Element)container.getNode()).getAttribute(attributeName);
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementId + '.' + attributeName + ']', ex);
        }
    }

    public Document getCachedDocument(PreprocessorContext context, String documentId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(documentId);
        if (container == null) {
            throw context.makeException("Can't find any document for the '" + documentId + "' id", null);
        }
        try {
            return (Document)container.getNode();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + documentId + ']', ex);
        }
    }

    public Element findCachedElement(PreprocessorContext context, String elementId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementId);
        if (container == null) {
            return null;
        }
        try {
            return (Element)container.getNode();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementId + ']', null);
        }
    }

    public Element getCachedElement(PreprocessorContext context, String elementId) {
        Element element = this.findCachedElement(context, elementId);
        if (element == null) {
            throw context.makeException("Can't find any active element for the '" + elementId + "' id", null);
        }
        return element;
    }

    public NodeList findCachedElementList(PreprocessorContext context, String elementListId) {
        NodeContainer container = (NodeContainer)context.getSharedResource(elementListId);
        if (container == null) {
            return null;
        }
        try {
            return container.getNodeList();
        }
        catch (ClassCastException ex) {
            throw context.makeException("Incompatible cached element type [" + elementListId + ']', ex);
        }
    }

    public NodeList getCachedElementList(PreprocessorContext context, String elementListId) {
        NodeList result = this.findCachedElementList(context, elementListId);
        if (result == null) {
            throw context.makeException("Can't find any active element list for the '" + elementListId + "' id", null);
        }
        return result;
    }

    public int getElementListSize(PreprocessorContext context, String elementListId) {
        return this.getCachedElementList(context, elementListId).getLength();
    }

    public static String buildPathForElement(Element element) {
        StringBuilder result = new StringBuilder();
        for (Node thenode = element; thenode != null; thenode = thenode.getParentNode()) {
            int level = 0;
            for (Node sibling = thenode; sibling != null; sibling = sibling.getPreviousSibling()) {
                ++level;
            }
            result.append('/').append(thenode.getNodeName()).append('{').append(level).append('}');
        }
        return result.toString();
    }

    public static String getFirstLevelTextContent(Node node) {
        NodeList list = node.getChildNodes();
        StringBuilder textContent = new StringBuilder(128);
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 3) continue;
            textContent.append(child.getTextContent());
        }
        return textContent.toString();
    }

    public String findElementForIndex(PreprocessorContext context, String elementListId, int elementIndex) {
        String elementCacheId = AbstractXMLFunction.makeElementId(elementListId, elementIndex);
        NodeContainer container = (NodeContainer)context.getSharedResource(elementCacheId);
        if (container == null) {
            container = (NodeContainer)context.getSharedResource(elementListId);
            if (container == null) {
                throw context.makeException("Can't find any active node list for the id '" + elementListId + '\'', null);
            }
            NodeList list = container.getNodeList();
            if (elementIndex < 0 || elementIndex >= list.getLength()) {
                throw context.makeException("The Element Index is out of bounds [" + elementIndex + ']', null);
            }
            Element element = (Element)list.item(elementIndex);
            if (element == null) {
                throw context.makeException("Wrong index [" + elementIndex + ']', null);
            }
            container = new NodeContainer(UID_COUNTER.getAndIncrement(), element);
            context.setSharedResource(elementCacheId, container);
        }
        return elementCacheId;
    }
}

