/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions.xml;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.xml.AbstractXMLFunction;
import com.igormaznitsa.jcp.expression.functions.xml.NodeContainer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class FunctionXML_XELEMENT
extends AbstractXMLFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.STRING}};

    @Override
    public String getName() {
        return "xml_xelement";
    }

    public Value executeStrStr(PreprocessorContext context, Value documentId, Value xPath) {
        String documentIdStr = documentId.asString();
        String pathStr = xPath.asString();
        String xpathElementId = FunctionXML_XELEMENT.makeXPathElementId(documentIdStr, pathStr);
        Document document = this.getCachedDocument(context, documentIdStr);
        Element elem = this.findCachedElement(context, xpathElementId);
        if (elem == null) {
            try {
                XPathExpression expression = this.prepareXPathExpression(pathStr);
                elem = (Element)expression.evaluate(document, XPathConstants.NODE);
                if (elem == null) {
                    throw context.makeException("Can't find element for xpath [" + pathStr + ']', null);
                }
            }
            catch (XPathExpressionException ex) {
                throw context.makeException("Error during XPath compilation [" + pathStr + ']', ex);
            }
            catch (ClassCastException ex) {
                throw context.makeException("Can't get element for XPath [" + pathStr + ']', ex);
            }
            NodeContainer container = new NodeContainer(UID_COUNTER.getAndIncrement(), elem);
            context.setSharedResource(xpathElementId, container);
        }
        return Value.valueOf(xpathElementId);
    }

    private XPathExpression prepareXPathExpression(String path) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return xpath.compile(path);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    public String getReference() {
        return "get element for XPath";
    }

    @Override
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

