/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.maven;

import com.igormaznitsa.jcp.JCPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.maven.MavenPropertiesImporter;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="preprocess", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresProject=true)
public class PreprocessorMojo
extends AbstractMojo
implements PreprocessorLogger {
    @Parameter(name="compileSourceRoots", defaultValue="${project.compileSourceRoots}", required=true, readonly=true)
    private List<String> compileSourceRoots;
    @Parameter(name="testCompileSourceRoots", defaultValue="${project.testCompileSourceRoots}", required=true, readonly=true)
    private List<String> testCompileSourceRoots;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(name="source", defaultValue="")
    private String source;
    @Parameter(name="destination", defaultValue="${project.build.directory}/generated-sources/preprocessed")
    private File destination;
    @Parameter(name="testDestination", defaultValue="${project.build.directory}/generated-test-sources/preprocessed")
    private File testDestination;
    @Parameter(name="inEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inEncoding;
    @Parameter(name="outEncoding", defaultValue="${project.build.sourceEncoding}")
    private String outEncoding;
    @Parameter(name="excluded")
    private String excluded;
    @Parameter(name="processing")
    private String processing;
    @Parameter(name="disableOut", defaultValue="false")
    private boolean disableOut;
    @Parameter(name="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(name="clear", defaultValue="false")
    private boolean clear;
    @Parameter(name="careForLastNextLine", defaultValue="false")
    private boolean careForLastNextLine;
    @Parameter(name="keepSrcRoot", defaultValue="false")
    private boolean keepSrcRoot;
    @Parameter(name="removeComments", defaultValue="false")
    private boolean removeComments;
    @Parameter(name="globalVars")
    private Properties globalVars;
    @Parameter(name="cfgFiles")
    private File[] cfgFiles;
    @Parameter(name="keepLines", defaultValue="true")
    private boolean keepLines;
    @Parameter(name="useTestSources", defaultValue="false")
    private boolean useTestSources;
    @Parameter(name="compareDestination", defaultValue="false")
    private boolean compareDestination;

    public void setUseTestSources(boolean flag) {
        this.useTestSources = flag;
    }

    public boolean getUseTestSources() {
        return this.useTestSources;
    }

    public void setClear(boolean flag) {
        this.clear = flag;
    }

    public boolean getClear() {
        return this.clear;
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public boolean getCarForLastNextLine() {
        return this.careForLastNextLine;
    }

    public void setKeepSrcRoot(boolean flag) {
        this.keepSrcRoot = flag;
    }

    public boolean getKeepSrcRoot() {
        return this.keepSrcRoot;
    }

    public void setGlobalVars(Properties vars) {
        this.globalVars = vars;
    }

    public Properties getGlobalVars() {
        return this.globalVars;
    }

    public void setCfgFiles(File[] files) {
        this.cfgFiles = files;
    }

    public File[] getCfgFiles() {
        return this.cfgFiles;
    }

    public void setCompareDestination(boolean flag) {
        this.compareDestination = flag;
    }

    public boolean isCompareDestination() {
        return this.compareDestination;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setTestDestination(File destination) {
        this.testDestination = destination;
    }

    public File getTestDestination() {
        return this.testDestination;
    }

    public void setInEncoding(String value) {
        this.inEncoding = value;
    }

    public String getInEncoding() {
        return this.inEncoding;
    }

    public void setOutEncoding(String value) {
        this.outEncoding = value;
    }

    public String getOutEncoding() {
        return this.outEncoding;
    }

    public void setExcluded(String excluded) {
        this.excluded = excluded;
    }

    public String getExcluded() {
        return this.excluded;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }

    public String getProcessing() {
        return this.processing;
    }

    public void setDisableOut(boolean value) {
        this.disableOut = value;
    }

    public boolean getDisableOut() {
        return this.disableOut;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setKeepLines(boolean keepLines) {
        this.keepLines = keepLines;
    }

    public boolean getKeepLines() {
        return this.keepLines;
    }

    public void setRemoveComments(boolean value) {
        this.removeComments = value;
    }

    public boolean getRemoveComments() {
        return this.removeComments;
    }

    private String makeSourceRootList() {
        String result = null;
        if (this.source != null && !this.source.isEmpty()) {
            result = this.source;
        } else if (this.project != null) {
            StringBuilder accum = new StringBuilder();
            for (String srcRoot : this.useTestSources ? this.testCompileSourceRoots : this.compileSourceRoots) {
                if (accum.length() > 0) {
                    accum.append(';');
                }
                accum.append(srcRoot);
            }
            result = accum.toString();
        }
        return result;
    }

    private void replaceSourceRootByPreprocessingDestinationFolder(PreprocessorContext context) throws IOException {
        if (this.project != null) {
            String sourceDirectories = context.getSourceDirectories();
            String[] splitted = sourceDirectories.split(";");
            List<String> sourceRoots = this.useTestSources ? this.testCompileSourceRoots : this.compileSourceRoots;
            ArrayList<String> sourceRootsAsCanonical = new ArrayList<String>();
            for (String src : sourceRoots) {
                sourceRootsAsCanonical.add(new File(src).getCanonicalPath());
            }
            for (String str : splitted) {
                int index = sourceRoots.indexOf(str);
                if (index < 0) {
                    File src = new File(str);
                    String canonicalPath = src.getCanonicalPath();
                    index = sourceRootsAsCanonical.indexOf(canonicalPath);
                }
                if (index < 0) continue;
                this.info("A Compile source root has been removed from the root list [" + sourceRoots.get(index) + ']');
                sourceRoots.remove(index);
            }
            String destinationDir = context.getDestinationDirectoryAsFile().getCanonicalPath();
            sourceRoots.add(destinationDir);
            this.info("The New compile source root has been added into the list [" + destinationDir + ']');
        }
    }

    PreprocessorContext makePreprocessorContext() throws IOException {
        PreprocessorContext context = new PreprocessorContext();
        context.setPreprocessorLogger(this);
        if (this.project != null) {
            MavenPropertiesImporter mavenPropertiesImporter = new MavenPropertiesImporter(context, this.project);
            context.registerSpecialVariableProcessor(mavenPropertiesImporter);
        }
        context.setSourceDirectories(this.makeSourceRootList());
        context.setDestinationDirectory(this.useTestSources ? this.testDestination.getCanonicalPath() : this.destination.getCanonicalPath());
        if (this.inEncoding != null) {
            context.setInCharacterEncoding(this.inEncoding);
        }
        if (this.outEncoding != null) {
            context.setOutCharacterEncoding(this.outEncoding);
        }
        if (this.excluded != null) {
            context.setExcludedFileExtensions(this.excluded);
        }
        if (this.processing != null) {
            context.setProcessingFileExtensions(this.processing);
        }
        this.info("Preprocess sources : " + context.getSourceDirectories());
        this.info("Preprocess destination : " + context.getDestinationDirectory());
        context.setCompareDestination(this.compareDestination);
        context.setClearDestinationDirBefore(this.clear);
        context.setCareForLastNextLine(this.careForLastNextLine);
        context.setRemoveComments(this.removeComments);
        context.setVerbose(this.getLog().isDebugEnabled() || this.verbose);
        context.setKeepLines(this.keepLines);
        context.setFileOutputDisabled(this.disableOut);
        if (this.cfgFiles != null && this.cfgFiles.length != 0) {
            for (File file : this.cfgFiles) {
                PreprocessorUtils.assertNotNull("Detected null where a config file was expected", file);
                context.addConfigFile(file);
            }
        }
        if (this.globalVars != null && !this.globalVars.isEmpty()) {
            for (String key : this.globalVars.stringPropertyNames()) {
                String value = this.globalVars.getProperty(key);
                PreprocessorUtils.assertNotNull("Can't find defined value for '" + key + "' global variable", value);
                context.setGlobalVariable(key, Value.recognizeRawString(value));
            }
        }
        return context;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        PreprocessorContext context = null;
        try {
            context = this.makePreprocessorContext();
        }
        catch (Exception ex) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(ex);
            throw new MojoExecutionException(pp == null ? ex.getMessage() : pp.toString(), pp == null ? ex : pp);
        }
        try {
            JCPreprocessor preprocessor = new JCPreprocessor(context);
            preprocessor.execute();
            if (!this.getKeepSrcRoot()) {
                this.replaceSourceRootByPreprocessingDestinationFolder(context);
            }
        }
        catch (Exception ex) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(ex);
            throw new MojoFailureException(pp == null ? ex.getMessage() : PreprocessorException.referenceAsString('.', pp), (Throwable)(pp == null ? ex : pp));
        }
    }

    @Override
    public void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    @Override
    public void info(String message) {
        this.getLog().info((CharSequence)message);
    }

    @Override
    public void warning(String message) {
        this.getLog().warn((CharSequence)message);
    }

    @Override
    public void debug(String message) {
        this.getLog().debug((CharSequence)message);
    }
}

