/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.removers;

import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class JavaCommentsRemover {
    private final Reader srcReader;
    private final Writer dstWriter;

    public JavaCommentsRemover(Reader src, Writer dst) {
        PreprocessorUtils.assertNotNull("The reader is null", src);
        PreprocessorUtils.assertNotNull("The writer is null", dst);
        this.srcReader = src;
        this.dstWriter = dst;
    }

    void skipUntilNextString() throws IOException {
        int chr;
        do {
            if ((chr = this.srcReader.read()) >= 0) continue;
            return;
        } while (chr != 10);
        this.dstWriter.write(chr);
    }

    void skipUntilClosingComments() throws IOException {
        boolean starFound = false;
        int chr;
        while ((chr = this.srcReader.read()) >= 0) {
            if (starFound) {
                if (chr == 47) {
                    return;
                }
                starFound = chr == 42;
                continue;
            }
            if (chr != 42) continue;
            starFound = true;
        }
        return;
    }

    public Writer process() throws IOException {
        int chr;
        boolean STATE_NORMAL = false;
        boolean STATE_INSIDE_STRING = true;
        int STATE_NEXT_SPECIAL_CHAR = 2;
        int STATE_FORWARD_SLASH = 3;
        int state = 0;
        while ((chr = this.srcReader.read()) >= 0) {
            block0 : switch (state) {
                case 0: {
                    switch (chr) {
                        case 34: {
                            this.dstWriter.write(chr);
                            state = 1;
                            break block0;
                        }
                        case 47: {
                            state = 3;
                            break block0;
                        }
                    }
                    this.dstWriter.write(chr);
                    break;
                }
                case 3: {
                    switch (chr) {
                        case 42: {
                            this.skipUntilClosingComments();
                            state = 0;
                            break block0;
                        }
                        case 47: {
                            this.skipUntilNextString();
                            state = 0;
                            break block0;
                        }
                    }
                    this.dstWriter.write(47);
                    this.dstWriter.write(chr);
                    state = 0;
                    break;
                }
                case 1: {
                    switch (chr) {
                        case 92: {
                            state = 2;
                            break;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    this.dstWriter.write(chr);
                    break;
                }
                case 2: {
                    this.dstWriter.write(chr);
                    state = 1;
                }
            }
        }
        return this.dstWriter;
    }
}

