/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.utils;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public enum PreprocessorUtils {

    public static final String LINE_END;

    public static String getFileExtension(File file) {
        String result = null;
        if (file != null) {
            result = FilenameUtils.getExtension(file.getName());
        }
        return result;
    }

    public static String[] splitExtensionCommaList(String extensions) {
        String[] result;
        PreprocessorUtils.assertNotNull("String of extensions is null", extensions);
        String trimmed = extensions.trim();
        if (trimmed.isEmpty()) {
            result = new String[]{};
        } else {
            result = PreprocessorUtils.splitForChar(extensions, ',');
            for (int li = 0; li < result.length; ++li) {
                result[li] = result[li].trim().toLowerCase(Locale.ENGLISH);
            }
        }
        return result;
    }

    public static void assertNotNull(String message, Object obj) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
    }

    public static BufferedReader makeFileReader(File file, String charset, int bufferSize) throws IOException {
        PreprocessorUtils.assertNotNull("File is null", file);
        PreprocessorUtils.assertNotNull("Charset is null", charset);
        if (!Charset.isSupported(charset)) {
            throw new IllegalArgumentException("Unsupported charset [" + charset + ']');
        }
        BufferedReader result = bufferSize <= 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset), bufferSize);
        return result;
    }

    public static String[] replaceChar(String[] source, char toBeReplaced, char replacement) {
        String[] result = new String[source.length];
        int index = 0;
        for (String curStr : source) {
            result[index++] = curStr.replace(toBeReplaced, replacement);
        }
        return result;
    }

    public static String extractTrimmedTail(String prefix, String value) {
        return PreprocessorUtils.extractTail(prefix, value).trim();
    }

    public static String extractTail(String prefix, String value) {
        PreprocessorUtils.assertNotNull("Prefix is null", prefix);
        PreprocessorUtils.assertNotNull("Value is null", value);
        if (prefix.length() > value.length()) {
            throw new IllegalArgumentException("Prefix is taller than the value");
        }
        return value.substring(prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        PreprocessorUtils.assertNotNull("Source is null", source);
        PreprocessorUtils.assertNotNull("Destination file is null", dest);
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source file is directory");
        }
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("Can't make directory [" + PreprocessorUtils.getFilePath(dest.getParentFile()) + ']');
        }
        FileChannel fileSrc = null;
        FileChannel fileDst = null;
        FileInputStream fileSrcInput = new FileInputStream(source);
        FileOutputStream fileOutput = null;
        try {
            long written;
            fileSrc = fileSrcInput.getChannel();
            fileOutput = new FileOutputStream(dest);
            fileDst = fileOutput.getChannel();
            long pos = 0L;
            for (long size = fileSrc.size(); size > 0L; size -= written) {
                written = fileSrc.transferTo(pos, size, fileDst);
                pos += written;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileSrcInput);
            IOUtils.closeQuietly(fileOutput);
            IOUtils.closeQuietly(fileDst);
            IOUtils.closeQuietly(fileSrc);
            throw throwable;
        }
        IOUtils.closeQuietly(fileSrcInput);
        IOUtils.closeQuietly(fileOutput);
        IOUtils.closeQuietly(fileDst);
        IOUtils.closeQuietly(fileSrc);
    }

    public static String processMacroses(String processingString, PreprocessorContext context) {
        int position;
        String result = processingString;
        while ((position = result.indexOf("/*$")) >= 0) {
            String leftPart = result.substring(0, position);
            int beginIndex = position;
            if ((position = result.indexOf("$*/", position)) < 0) break;
            String macrosBody = result.substring(beginIndex + 3, position);
            String rightPart = result.substring(position + 3);
            Value value = Expression.evalExpression(macrosBody, context);
            result = leftPart + value.toString() + rightPart;
        }
        return result;
    }

    private static void checkFile(File file) throws IOException {
        PreprocessorUtils.assertNotNull("File is null", file);
        if (!file.isFile()) {
            throw new FileNotFoundException("File " + PreprocessorUtils.getFilePath(file) + " doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readWholeTextFileIntoArray(File file, String encoding, AtomicBoolean endedByNextLine) throws IOException {
        PreprocessorUtils.checkFile(file);
        String enc = encoding == null ? "UTF8" : encoding;
        BufferedReader srcBufferedReader = PreprocessorUtils.makeFileReader(file, enc, (int)file.length());
        ArrayList<String> strContainer = new ArrayList<String>(1024);
        try {
            int chr;
            StringBuilder buffer = new StringBuilder();
            boolean stringEndedByNextLine = false;
            boolean meetCR = false;
            while ((chr = srcBufferedReader.read()) >= 0) {
                if (chr == 10) {
                    stringEndedByNextLine = true;
                    strContainer.add(buffer.toString());
                    buffer.setLength(0);
                    meetCR = false;
                    continue;
                }
                if (chr == 13) {
                    if (meetCR) {
                        buffer.append((char)chr);
                        continue;
                    }
                    stringEndedByNextLine = false;
                    meetCR = true;
                    continue;
                }
                if (meetCR) {
                    buffer.append('\r');
                }
                meetCR = false;
                stringEndedByNextLine = false;
                buffer.append((char)chr);
            }
            if (buffer.length() != 0) {
                strContainer.add(buffer.toString());
                buffer.setLength(0);
            }
            if (endedByNextLine != null) {
                endedByNextLine.set(stringEndedByNextLine);
            }
        }
        finally {
            srcBufferedReader.close();
        }
        return strContainer.toArray(new String[strContainer.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(File file) throws IOException {
        int len;
        PreprocessorUtils.checkFile(file);
        ByteBuffer buffer = ByteBuffer.allocate(len);
        FileChannel inChannel = new FileInputStream(file).getChannel();
        try {
            int read;
            for (len = (int)file.length(); len > 0; len -= read) {
                read = inChannel.read(buffer);
                if (read >= 0) continue;
                throw new IOException("Can't read whole file [" + PreprocessorUtils.getFilePath(file) + '\'');
            }
        }
        finally {
            IOUtils.closeQuietly(inChannel);
        }
        return buffer.array();
    }

    public static String[] splitForEqualChar(String string) {
        String[] result;
        int index = string.indexOf(61);
        if (index < 0) {
            result = new String[]{string};
        } else {
            String leftPart = string.substring(0, index).trim();
            String rightPart = string.substring(index + 1).trim();
            result = new String[]{leftPart, rightPart};
        }
        return result;
    }

    public static String[] splitForChar(String string, char delimiter) {
        char[] array = string.toCharArray();
        StringBuilder buffer = new StringBuilder(array.length >> 1 == 0 ? 1 : array.length >> 1);
        ArrayList<String> tokens = new ArrayList<String>(10);
        for (char curChar : array) {
            if (curChar == delimiter) {
                if (buffer.length() == 0) continue;
                tokens.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(curChar);
        }
        if (buffer.length() != 0) {
            tokens.add(buffer.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String normalizeVariableName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim().toLowerCase(Locale.ENGLISH);
    }

    public static String getFilePath(File file) {
        String result = "";
        if (file != null) {
            try {
                result = file.getCanonicalPath();
            }
            catch (IOException ex) {
                result = file.getAbsolutePath();
            }
        }
        return result;
    }

    public static void throwPreprocessorException(String msg, String processingString, File srcFile, int nextStringIndex, Throwable cause) {
        throw new PreprocessorException(msg, processingString, new FilePositionInfo[]{new FilePositionInfo(srcFile, nextStringIndex)}, cause);
    }

    public static String[] replaceStringPrefix(String[] allowedPrefixesToBeReplaced, String replacement, String[] strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            String detectedPrefix = null;
            for (String prefix : allowedPrefixesToBeReplaced) {
                if (!str.startsWith(prefix) || detectedPrefix != null && detectedPrefix.length() >= prefix.length()) continue;
                detectedPrefix = prefix;
            }
            result[i] = detectedPrefix != null ? replacement + str.substring(detectedPrefix.length()) : str;
        }
        return result;
    }

    public static String getNextLineCodes() {
        return System.getProperty("line.separator", "\r\n");
    }

    public static String leftTrim(String rawString) {
        char ch;
        int firstNonSpace = 0;
        for (int i = 0; i < rawString.length() && (ch = rawString.charAt(i)) <= ' '; ++i) {
            ++firstNonSpace;
        }
        return rawString.substring(firstNonSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileContentEquals(File src, File dst) throws IOException {
        if (src == null && dst == null) {
            return true;
        }
        if (src == null || dst == null) {
            return false;
        }
        if (src.isDirectory() && dst.isDirectory()) {
            return true;
        }
        if (src.isDirectory() || dst.isDirectory()) {
            return false;
        }
        if (src.length() != dst.length()) {
            return false;
        }
        int bufferSize = Math.min((int)src.length(), 65536);
        byte[] srcBuffer = new byte[bufferSize];
        byte[] dstBuffer = new byte[bufferSize];
        BufferedInputStream srcIn = new BufferedInputStream(new FileInputStream(src), bufferSize);
        BufferedInputStream dstIn = new BufferedInputStream(new FileInputStream(dst), bufferSize);
        try {
            while (true) {
                int readSrc = IOUtils.read(srcIn, srcBuffer);
                int readDst = IOUtils.read(dstIn, dstBuffer);
                if (readDst != readSrc) {
                    boolean bl = false;
                    return bl;
                }
                if (readSrc == 0) break;
                if (Arrays.equals(srcBuffer, dstBuffer)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(srcIn);
            IOUtils.closeQuietly(dstIn);
        }
    }

    static {
        String jcpLlineEnd = System.getProperty("jcp.line.separator");
        LINE_END = jcpLlineEnd == null ? System.getProperty("line.separator", "\r\n") : jcpLlineEnd;
    }
}

