/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.utils;

import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class ResetablePrinter {
    private final CharArrayWriter outStream;

    public ResetablePrinter(int initialCapacity) {
        this.outStream = new CharArrayWriter(initialCapacity);
    }

    public boolean isEmpty() {
        return this.outStream.size() == 0;
    }

    public void writeBufferTo(Writer writer) throws IOException {
        this.outStream.flush();
        writer.write(this.outStream.toCharArray());
        writer.flush();
    }

    public int getSize() {
        return this.outStream.size();
    }

    public void reset() {
        this.outStream.reset();
    }

    public void print(String text) throws IOException {
        for (char chr : text.toCharArray()) {
            this.outStream.write(chr);
        }
    }

    public void println(String text) throws IOException {
        for (char chr : text.toCharArray()) {
            this.outStream.write(chr);
        }
        this.outStream.write(PreprocessorUtils.LINE_END, 0, PreprocessorUtils.LINE_END.length());
    }
}

