/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp;

import com.igormaznitsa.jcp.JCPreprocessor;
import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.JCPSpecialVariableProcessor;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class InfoHelper {
    public static final String DELIMITER = "-------------------------------------------------";

    private InfoHelper() {
    }

    @Nonnull
    public static String getVersion() {
        return "v 6.1.4";
    }

    @Nonnull
    public static String getCopyright() {
        return "2003-2017 Author: Igor A. Maznitsa (igor.maznitsa@igormaznitsa.com)";
    }

    @Nonnull
    public static String getSite() {
        return "Project page: https://github.com/raydac/java-comment-preprocessor";
    }

    @Nonnull
    public static String getProductName() {
        return "Java Comment Preprocessor";
    }

    @Nonnull
    @MustNotContainNull
    public static List<String> makeTextForHelpInfo() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(JCPreprocessor.class.getCanonicalName() + " [@cfg_file] [cli_directives]");
        result.add("");
        result.add("Command line directives\n------------");
        result.add("\n(!)Historically all directives are prefixed by '/' but since 5.3.3 both '-' and '--' prefixes are allowed\n");
        result.add(InfoHelper.makeColumns("@cfg_file", "file contains global definition list", 14));
        for (CommandLineHandler handler : JCPreprocessor.getCommandLineHandlers()) {
            result.add(InfoHelper.makeCommandLineKeyReference(handler));
        }
        result.add(DELIMITER);
        result.add("Preprocessor directives (THE PREPROCESSOR IS A TWO-PASS ONE)\n------------");
        for (AbstractDirectiveHandler abstractDirectiveHandler : AbstractDirectiveHandler.DIRECTIVES) {
            result.add(InfoHelper.makeDirectiveReference(abstractDirectiveHandler));
        }
        result.add(DELIMITER);
        result.add("Special string directives\n------------");
        result.add(InfoHelper.makeSpecialDirectiveReference("//$", "replace macroses in following text and out result"));
        result.add(InfoHelper.makeSpecialDirectiveReference("//$$", "works like //$ but without macros replacement"));
        result.add(InfoHelper.makeSpecialDirectiveReference("/*-*/", "discard the following text tail"));
        result.add("Operators\n------------");
        for (AbstractOperator abstractOperator : AbstractOperator.ALL_OPERATORS) {
            result.add(InfoHelper.makeOperatorReference(abstractOperator));
        }
        result.add(DELIMITER);
        result.add("Functions\n------------");
        for (AbstractFunction abstractFunction : AbstractFunction.ALL_FUNCTIONS) {
            result.add(InfoHelper.makeFunctionReference(abstractFunction));
        }
        result.add(DELIMITER);
        result.add("Data types\n------------");
        result.add("BOOLEAN: true,false");
        result.add("INTEGER: 2374,0x56FE (signed 64 bit)");
        result.add("STRING : \"Hello World!\" (or $Hello World!$ for the command string)");
        result.add("FLOAT  : 0.745 (signed 32 bit)");
        result.add(DELIMITER);
        result.add("Special variables\n------------");
        for (JCPSpecialVariableProcessor.NameReferencePair p : JCPSpecialVariableProcessor.getReference()) {
            result.add(InfoHelper.makeSpecialVariableReference(p));
        }
        return result;
    }

    @Nonnull
    private static String makeSpecialVariableReference(@Nonnull JCPSpecialVariableProcessor.NameReferencePair p) {
        String name = p.getName();
        String ref = p.getReference();
        return InfoHelper.makeColumns(name, ref, 24);
    }

    @Nonnull
    private static String makeCommandLineKeyReference(@Nonnull CommandLineHandler handler) {
        String key = handler.getKeyName();
        String descr = handler.getDescription();
        return InfoHelper.makeColumns(key, descr, 14);
    }

    @Nonnull
    private static String makeDirectiveReference(@Nonnull AbstractDirectiveHandler directive) {
        StringBuilder activityPasses = new StringBuilder();
        int i = 0;
        if (directive.isGlobalPhaseAllowed()) {
            ++i;
            activityPasses.append("1st");
        }
        if (directive.isPreprocessingPhaseAllowed()) {
            if (i > 0) {
                activityPasses.append(',');
            }
            activityPasses.append("2th");
            ++i;
        }
        activityPasses.append(i > 1 ? "passes" : " pass");
        String directiveName = directive.getFullName();
        String descr = (directive.isDeprecated() ? "{DEPRECATED} " : "") + directive.getReference() + " (" + activityPasses.toString() + ')';
        return InfoHelper.makeColumns(directiveName, descr, 16);
    }

    @Nonnull
    private static String makeSpecialDirectiveReference(@Nonnull String name, @Nonnull String reference) {
        return InfoHelper.makeColumns(name, reference, 14);
    }

    @Nonnull
    private static String makeOperatorReference(@Nonnull AbstractOperator operator) {
        String operatorName = operator.getKeyword();
        String descr = operator.getReference();
        return InfoHelper.makeColumns(operatorName, descr, 14);
    }

    @Nonnull
    private static String makeFunctionReference(@Nonnull AbstractFunction func) {
        String funcName = func.getName();
        String descr = func.getReference();
        StringBuilder variants = new StringBuilder("  [");
        String result = func.getResultType().getSignature().toUpperCase(Locale.ENGLISH);
        int variantIndex = 0;
        for (ValueType[] signature : func.getAllowedArgumentTypes()) {
            if (variantIndex > 0) {
                variants.append(" | ");
            }
            variants.append(result).append(' ').append(funcName).append(" (");
            for (int i = 0; i < signature.length; ++i) {
                if (i > 0) {
                    variants.append(',');
                }
                variants.append(signature[i].getSignature().toUpperCase(Locale.ENGLISH));
            }
            variants.append(')');
            ++variantIndex;
        }
        variants.append(']');
        return InfoHelper.makeColumns(funcName, descr, 24) + variants.toString();
    }

    @Nonnull
    private static String makeColumns(@Nonnull String name, @Nonnull String reference, int firstColumnWidth) {
        int spaces = firstColumnWidth - name.length();
        StringBuilder result = new StringBuilder(name);
        for (int i = 0; i < spaces; ++i) {
            result.append(' ');
        }
        result.append(reference);
        return result.toString();
    }
}

