/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp;

import com.igormaznitsa.jcp.InfoHelper;
import com.igormaznitsa.jcp.cmdline.AllowWhitespaceDirectiveHandler;
import com.igormaznitsa.jcp.cmdline.CareForLastNextLineCharHandler;
import com.igormaznitsa.jcp.cmdline.ClearDstDirectoryHandler;
import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.cmdline.CompareDestinationContentHandler;
import com.igormaznitsa.jcp.cmdline.CopyFileAttributesHandler;
import com.igormaznitsa.jcp.cmdline.DestinationDirectoryHandler;
import com.igormaznitsa.jcp.cmdline.ExcludeFoldersHandler;
import com.igormaznitsa.jcp.cmdline.ExcludedFileExtensionsHandler;
import com.igormaznitsa.jcp.cmdline.FileExtensionsHandler;
import com.igormaznitsa.jcp.cmdline.GlobalVariableDefiningFileHandler;
import com.igormaznitsa.jcp.cmdline.GlobalVariableHandler;
import com.igormaznitsa.jcp.cmdline.HelpHandler;
import com.igormaznitsa.jcp.cmdline.InCharsetHandler;
import com.igormaznitsa.jcp.cmdline.KeepLineHandler;
import com.igormaznitsa.jcp.cmdline.OutCharsetHandler;
import com.igormaznitsa.jcp.cmdline.PreserveIndentDirectiveHandler;
import com.igormaznitsa.jcp.cmdline.RemoveCommentsHandler;
import com.igormaznitsa.jcp.cmdline.SourceDirectoryHandler;
import com.igormaznitsa.jcp.cmdline.UnknownAsFalseHandler;
import com.igormaznitsa.jcp.cmdline.VerboseHandler;
import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.ExcludeIfDirectiveHandler;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.jcp.utils.antpathmatcher.AntPathMatcher;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import hidden.jcp.org.apache.commons.io.FileUtils;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JCPreprocessor {
    private final PreprocessorContext context;
    static final CommandLineHandler[] COMMAND_LINE_HANDLERS = new CommandLineHandler[]{new HelpHandler(), new InCharsetHandler(), new OutCharsetHandler(), new ClearDstDirectoryHandler(), new SourceDirectoryHandler(), new DestinationDirectoryHandler(), new FileExtensionsHandler(), new ExcludedFileExtensionsHandler(), new AllowWhitespaceDirectiveHandler(), new RemoveCommentsHandler(), new KeepLineHandler(), new CompareDestinationContentHandler(), new VerboseHandler(), new GlobalVariableDefiningFileHandler(), new GlobalVariableHandler(), new CareForLastNextLineCharHandler(), new PreserveIndentDirectiveHandler(), new ExcludeFoldersHandler(), new CopyFileAttributesHandler(), new UnknownAsFalseHandler()};

    @Nonnull
    public static Iterable<CommandLineHandler> getCommandLineHandlers() {
        return Arrays.asList(COMMAND_LINE_HANDLERS);
    }

    @Nonnull
    public PreprocessorContext getContext() {
        return this.context;
    }

    public JCPreprocessor(@Nonnull PreprocessorContext context) {
        Assertions.assertNotNull("Configurator is null", context);
        this.context = context;
    }

    @Nonnull
    public PreprocessingStatistics execute() throws IOException {
        long timeStart = System.currentTimeMillis();
        this.processCfgFiles();
        File[] srcDirs = this.context.getSourceDirectoryAsFiles();
        Collection<FileInfoContainer> filesToBePreprocessed = this.findAllFilesToBePreprocessed(srcDirs, this.context.getExcludedFolderPatterns());
        List<PreprocessingState.ExcludeIfInfo> excludedIf = this.processGlobalDirectives(filesToBePreprocessed);
        this.processFileExclusion(excludedIf);
        if (!this.context.isFileOutputDisabled()) {
            this.createDestinationDirectory();
        }
        PreprocessingStatistics stat = this.preprocessFiles(filesToBePreprocessed);
        long elapsedTime = System.currentTimeMillis() - timeStart;
        this.context.logInfo("-----------------------------------------------------------------");
        this.context.logInfo("Completed, preprocessed " + stat.getNumberOfPreprocessed() + " files, copied " + stat.getNumberOfCopied() + " files, elapsed time " + elapsedTime + "ms");
        return stat;
    }

    private void processFileExclusion(@Nonnull @MustNotContainNull List<PreprocessingState.ExcludeIfInfo> foundExcludeIf) {
        String DIRECTIVE_NAME = new ExcludeIfDirectiveHandler().getFullName();
        for (PreprocessingState.ExcludeIfInfo item : foundExcludeIf) {
            String condition = item.getCondition();
            File file = item.getFileInfoContainer().getSourceFile();
            Value val = null;
            if (this.context.isVerbose()) {
                this.context.logForVerbose("Processing condition '" + condition + "' for file '" + file.getAbsolutePath() + "'");
            }
            try {
                val = Expression.evalExpression(condition, this.context);
            }
            catch (IllegalArgumentException ex) {
                throw new PreprocessorException("Wrong expression at " + DIRECTIVE_NAME, condition, new FilePositionInfo[]{new FilePositionInfo(file, item.getStringIndex())}, ex);
            }
            if (val.getType() != ValueType.BOOLEAN) {
                throw new PreprocessorException("Expression at " + DIRECTIVE_NAME + " is not a boolean one", condition, new FilePositionInfo[]{new FilePositionInfo(file, item.getStringIndex())}, null);
            }
            if (!val.asBoolean().booleanValue()) continue;
            item.getFileInfoContainer().setExcluded(true);
            if (!this.context.isVerbose()) continue;
            this.context.logForVerbose("File '" + file.getAbsolutePath() + "' excluded because '" + condition + "' returns TRUE");
        }
    }

    @Nonnull
    @MustNotContainNull
    private List<PreprocessingState.ExcludeIfInfo> processGlobalDirectives(@Nonnull @MustNotContainNull Collection<FileInfoContainer> files) throws IOException {
        ArrayList<PreprocessingState.ExcludeIfInfo> result = new ArrayList<PreprocessingState.ExcludeIfInfo>();
        for (FileInfoContainer fileRef : files) {
            if (fileRef.isExcludedFromPreprocessing() || fileRef.isForCopyOnly()) continue;
            long startTime = System.currentTimeMillis();
            result.addAll(fileRef.processGlobalDirectives(null, this.context));
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (!this.context.isVerbose()) continue;
            this.context.logForVerbose("Global search completed for file '" + PreprocessorUtils.getFilePath(fileRef.getSourceFile()) + "', elapsed time " + elapsedTime + "ms");
        }
        return result;
    }

    @Nonnull
    private PreprocessingStatistics preprocessFiles(@Nonnull @MustNotContainNull Collection<FileInfoContainer> files) throws IOException {
        int prepFileCounter = 0;
        int copFileCounter = 0;
        for (FileInfoContainer fileRef : files) {
            if (fileRef.isExcludedFromPreprocessing()) continue;
            if (fileRef.isForCopyOnly()) {
                if (this.context.isFileOutputDisabled()) continue;
                File destinationFile = this.context.createDestinationFileForPath(fileRef.getDestinationFilePath());
                boolean doCopy = true;
                if (this.context.isCompareDestination() && PreprocessorUtils.isFileContentEquals(fileRef.getSourceFile(), destinationFile)) {
                    doCopy = false;
                    if (this.context.isVerbose()) {
                        this.context.logForVerbose("Ignore copying because exists with the same content : " + PreprocessorUtils.getFilePath(fileRef.getSourceFile()) + " -> {dst}" + fileRef.getDestinationFilePath());
                    }
                }
                if (!doCopy) continue;
                if (this.context.isVerbose()) {
                    this.context.logForVerbose("Copy file " + PreprocessorUtils.getFilePath(fileRef.getSourceFile()) + " -> {dst}" + fileRef.getDestinationFilePath());
                }
                PreprocessorUtils.copyFile(fileRef.getSourceFile(), destinationFile, this.context.isCopyFileAttributes());
                ++copFileCounter;
                continue;
            }
            long startTime = System.currentTimeMillis();
            fileRef.preprocessFile(null, this.context);
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (this.context.isVerbose()) {
                this.context.logForVerbose("File preprocessing completed  '" + PreprocessorUtils.getFilePath(fileRef.getSourceFile()) + "', elapsed time " + elapsedTime + "ms");
            }
            ++prepFileCounter;
        }
        PreprocessingStatistics stat = new PreprocessingStatistics(prepFileCounter, copFileCounter);
        return stat;
    }

    private void createDestinationDirectory() throws IOException {
        boolean destinationExistsAndDirectory;
        File destination = this.context.getDestinationDirectoryAsFile();
        boolean bl = destinationExistsAndDirectory = destination.exists() && destination.isDirectory();
        if (this.context.doesClearDestinationDirBefore() && destinationExistsAndDirectory) {
            try {
                FileUtils.cleanDirectory(destination);
            }
            catch (IOException ex) {
                throw new IOException("I can't clean the destination directory [" + PreprocessorUtils.getFilePath(destination) + ']', ex);
            }
        }
        if (!destinationExistsAndDirectory && !destination.mkdirs()) {
            throw new IOException("I can't make the destination directory [" + PreprocessorUtils.getFilePath(destination) + ']');
        }
    }

    @Nonnull
    @MustNotContainNull
    private Collection<FileInfoContainer> findAllFilesToBePreprocessed(@Nonnull @MustNotContainNull File[] srcDirs, @Nonnull @MustNotContainNull String[] excludedFolderPatterns) throws IOException {
        ArrayList<FileInfoContainer> result = new ArrayList<FileInfoContainer>();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (File dir : srcDirs) {
            String canonicalPathForSrcDirectory = dir.getCanonicalPath();
            if (!canonicalPathForSrcDirectory.endsWith(File.separator)) {
                canonicalPathForSrcDirectory = canonicalPathForSrcDirectory + File.separator;
            }
            Set<File> allFoundFiles = this.findAllFiles(canonicalPathForSrcDirectory, dir, antPathMatcher, excludedFolderPatterns);
            for (File file : allFoundFiles) {
                if (this.context.isFileExcludedFromProcess(file)) continue;
                String filePath = file.getCanonicalPath();
                String relativePath = filePath.substring(canonicalPathForSrcDirectory.length());
                FileInfoContainer reference = new FileInfoContainer(file, relativePath, !this.context.isFileAllowedToBeProcessed(file));
                result.add(reference);
            }
        }
        return result;
    }

    @Nonnull
    private Set<File> findAllFiles(@Nonnull String baseFolderCanonicalPath, @Nonnull File dir, @Nonnull AntPathMatcher antPathMatcher, @Nonnull @MustNotContainNull String[] excludedFolderPatterns) throws IOException {
        HashSet<File> result = new HashSet<File>();
        File[] allowedFiles = dir.listFiles();
        String normalizedBasePath = FilenameUtils.normalize(baseFolderCanonicalPath, true);
        for (File file : allowedFiles) {
            if (file.isDirectory()) {
                boolean process = true;
                String folderPath = file.getCanonicalPath();
                String excludingPattern = null;
                if (excludedFolderPatterns.length != 0) {
                    String subPathInBase = folderPath.substring(normalizedBasePath.length());
                    for (String s : excludedFolderPatterns) {
                        if (!antPathMatcher.match(s, subPathInBase)) continue;
                        excludingPattern = s;
                        process = false;
                        break;
                    }
                }
                if (process) {
                    result.addAll(this.findAllFiles(baseFolderCanonicalPath, file, antPathMatcher, excludedFolderPatterns));
                    continue;
                }
                this.context.logForVerbose("Folder '" + folderPath + "' excluded for pattern '" + excludingPattern + "'");
                continue;
            }
            result.add(file);
        }
        return result;
    }

    public static void main(String ... args) {
        PreprocessorContext preprocessorContext;
        JCPreprocessor.printHeader();
        String[] normalizedStrings = PreprocessorUtils.replaceStringPrefix(new String[]{"--", "-"}, "/", PreprocessorUtils.replaceChar(args, '$', '\"'));
        try {
            preprocessorContext = JCPreprocessor.processCommandString(null, args, normalizedStrings);
        }
        catch (IOException ex) {
            System.err.println("Error during command line processing [" + ex.getMessage() + ']');
            System.exit(1);
            throw new RuntimeException("To show compiler executiion stop");
        }
        JCPreprocessor preprocessor = new JCPreprocessor(preprocessorContext);
        try {
            preprocessor.execute();
        }
        catch (Exception unexpected) {
            System.err.println(PreprocessorException.referenceAsString(' ', unexpected));
            System.exit(1);
        }
        System.exit(0);
    }

    @Nonnull
    private static PreprocessorContext processCommandString(@Nullable PreprocessorContext context, @Nonnull @MustNotContainNull String[] originalStrings, @Nonnull @MustNotContainNull String[] normalizedStrings) throws IOException {
        PreprocessorContext result = context == null ? new PreprocessorContext() : context;
        for (int i = 0; i < normalizedStrings.length; ++i) {
            String arg = normalizedStrings[i];
            boolean processed = false;
            for (CommandLineHandler processor : JCPreprocessor.getCommandLineHandlers()) {
                if (!processor.processCommandLineKey(arg, result)) continue;
                processed = true;
                if (!(processor instanceof HelpHandler)) break;
                JCPreprocessor.help();
                System.exit(2);
                break;
            }
            if (processed) continue;
            System.err.println("Can't process a command line argument, may be some wrong usage : " + originalStrings[i]);
            System.out.println();
            System.out.println("Take a look at the CLI help below, please");
            JCPreprocessor.help();
            System.exit(1);
        }
        return result;
    }

    void processCfgFiles() throws IOException {
        for (File file : this.context.getConfigFiles()) {
            String[] wholeFile = PreprocessorUtils.readWholeTextFileIntoArray(file, "UTF-8", null);
            int readStringIndex = -1;
            for (String curString : wholeFile) {
                String trimmed = curString.trim();
                ++readStringIndex;
                if (trimmed.isEmpty() || trimmed.charAt(0) == '#') continue;
                if (trimmed.charAt(0) == '@') {
                    PreprocessorUtils.throwPreprocessorException("You can't start any string in a global variable defining file with '@'", trimmed, file, readStringIndex, null);
                    continue;
                }
                if (trimmed.charAt(0) == '/') {
                    boolean processed = false;
                    try {
                        for (CommandLineHandler handler : JCPreprocessor.getCommandLineHandlers()) {
                            if (this.context.isVerbose()) {
                                this.context.logForVerbose("Processing \u0441onfig file key '" + trimmed + "' at " + file.getName() + ':' + (readStringIndex + 1));
                            }
                            if (!handler.processCommandLineKey(trimmed, this.context)) continue;
                            processed = true;
                            break;
                        }
                    }
                    catch (Exception unexpected) {
                        PreprocessorUtils.throwPreprocessorException("Exception during directive processing", trimmed, file, readStringIndex, unexpected);
                    }
                    if (processed) continue;
                    PreprocessorUtils.throwPreprocessorException("Unsupported or disallowed directive", trimmed, file, readStringIndex, null);
                    continue;
                }
                String[] splitted = PreprocessorUtils.splitForEqualChar(trimmed);
                if (splitted.length != 2) {
                    PreprocessorUtils.throwPreprocessorException("Wrong variable definition", trimmed, file, readStringIndex, null);
                }
                String name = splitted[0].trim().toLowerCase(Locale.ENGLISH);
                String expression = splitted[1].trim();
                if (name.isEmpty()) {
                    PreprocessorUtils.throwPreprocessorException("Empty variable name detected", trimmed, file, readStringIndex, null);
                }
                try {
                    Value result = Expression.evalExpression(expression, this.context);
                    this.context.setGlobalVariable(name, result);
                    if (!this.context.isVerbose()) continue;
                    this.context.logForVerbose("Register global variable " + name + " = " + result.toString() + " (" + file.getName() + ':' + (readStringIndex + 1) + ')');
                }
                catch (Exception unexpected) {
                    PreprocessorUtils.throwPreprocessorException("Can't process the global variable definition", trimmed, file, readStringIndex, unexpected);
                }
            }
        }
    }

    private static void printHeader() {
        System.out.println(InfoHelper.getProductName() + ' ' + InfoHelper.getVersion());
        System.out.println(InfoHelper.getSite());
        System.out.println(InfoHelper.getCopyright());
    }

    private static void help() {
        System.out.println();
        for (String str : InfoHelper.makeTextForHelpInfo()) {
            System.out.println(str);
        }
    }

    public static final class PreprocessingStatistics {
        private final int numberOfPreprocessed;
        private final int numberOfCopied;

        public PreprocessingStatistics(int numberOfPreprocessed, int numberOfCopied) {
            this.numberOfPreprocessed = numberOfPreprocessed;
            this.numberOfCopied = numberOfCopied;
        }

        public int getNumberOfCopied() {
            return this.numberOfCopied;
        }

        public int getNumberOfPreprocessed() {
            return this.numberOfPreprocessed;
        }
    }
}

