/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.ant;

import com.igormaznitsa.jcp.JCPreprocessor;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.annotation.ImplementationNote;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class PreprocessTask
extends Task
implements PreprocessorLogger,
SpecialVariableProcessor {
    private File sourceDirectory = null;
    private File destinationDirectory = null;
    private String inCharSet = null;
    private String outCharSet = null;
    private String excludedExtensions = null;
    private String processing = null;
    private String excludedFolders = null;
    private boolean disableOut = false;
    private boolean verbose = false;
    private boolean clearDstFlag = false;
    private boolean removeComments = false;
    private boolean keepLines = false;
    private boolean careForLastNextLine = false;
    private boolean compareDestination = false;
    private boolean allowWhitespace = false;
    private boolean preserveIndent = false;
    private boolean copyFileAttributes = false;
    private boolean unknownVarAsFalse = false;
    private Map<String, Value> antVariables;
    private final List<Global> globalVariables = new ArrayList<Global>();
    private final List<CfgFile> configFiles = new ArrayList<CfgFile>();

    public void setCopyFileAttributes(boolean flag) {
        this.copyFileAttributes = flag;
    }

    public void setAllowWhitespace(boolean flag) {
        this.allowWhitespace = flag;
    }

    public void setPreserveIndent(boolean flag) {
        this.preserveIndent = flag;
    }

    public void setCompareDestiation(boolean flag) {
        this.compareDestination = flag;
    }

    public void setSource(@Nonnull File src) {
        this.sourceDirectory = src;
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public void setDestination(@Nonnull File dst) {
        this.destinationDirectory = dst;
    }

    public void setInCharset(@Nonnull String charSet) {
        this.inCharSet = charSet;
    }

    public void setOutCharset(@Nonnull String charSet) {
        this.outCharSet = charSet;
    }

    public void setUnknownVarAsFalse(boolean flag) {
        this.unknownVarAsFalse = flag;
    }

    public void setExcluded(@Nonnull String ext) {
        this.excludedExtensions = ext;
    }

    public void setProcessing(@Nonnull String ext) {
        this.processing = ext;
    }

    public void setExcludedFolders(@Nonnull String value) {
        this.excludedFolders = value;
    }

    public void setClear(boolean flag) {
        this.clearDstFlag = flag;
    }

    public void setRemoveComments(boolean flag) {
        this.removeComments = flag;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setKeepLines(boolean flag) {
        this.keepLines = flag;
    }

    public void setDisableOut(boolean flag) {
        this.disableOut = flag;
    }

    @Nonnull
    @ImplementationNote(value="Do not change because for ANT!")
    public Global createGlobal() {
        Global result = new Global();
        this.globalVariables.add(result);
        return result;
    }

    @Nonnull
    @ImplementationNote(value="Do not change because for ANT!")
    public CfgFile createCfgFile() {
        CfgFile result = new CfgFile();
        this.configFiles.add(result);
        return result;
    }

    private void fillCfgFiles(@Nonnull PreprocessorContext context) {
        for (CfgFile f : this.configFiles) {
            context.addConfigFile(Assertions.assertNotNull("File must not be null", f.getFile()));
        }
    }

    private void fillGlobalVars(@Nonnull PreprocessorContext context) {
        for (Global g : this.globalVariables) {
            context.setGlobalVariable(Assertions.assertNotNull("Name must not be null", g.getName()), Value.recognizeRawString(Assertions.assertNotNull("Value must not be null", g.getValue())));
        }
    }

    @Nonnull
    PreprocessorContext generatePreprocessorContext() {
        this.fillAntVariables();
        PreprocessorContext context = new PreprocessorContext();
        context.setPreprocessorLogger(this);
        context.registerSpecialVariableProcessor(this);
        if (this.destinationDirectory != null) {
            context.setDestinationDirectory(this.destinationDirectory.getAbsolutePath());
        }
        if (this.sourceDirectory != null) {
            context.setSourceDirectories(this.sourceDirectory.getAbsolutePath());
        } else {
            context.setSourceDirectories(this.getProject().getBaseDir().getAbsolutePath());
        }
        if (this.excludedExtensions != null) {
            context.setExcludedFileExtensions(this.excludedExtensions);
        }
        if (this.processing != null) {
            context.setProcessingFileExtensions(this.processing);
        }
        if (this.inCharSet != null) {
            context.setInCharacterEncoding(this.inCharSet);
        }
        if (this.outCharSet != null) {
            context.setOutCharacterEncoding(this.outCharSet);
        }
        context.setCompareDestination(this.compareDestination);
        context.setClearDestinationDirBefore(this.clearDstFlag);
        context.setFileOutputDisabled(this.disableOut);
        context.setRemoveComments(this.removeComments);
        context.setVerbose(this.verbose);
        context.setKeepLines(this.keepLines);
        context.setCareForLastNextLine(this.careForLastNextLine);
        context.setAllowWhitespace(this.allowWhitespace);
        context.setPreserveIndent(this.preserveIndent);
        context.setCopyFileAttributes(this.copyFileAttributes);
        context.setUnknownVariableAsFalse(this.unknownVarAsFalse);
        if (this.excludedFolders != null && !this.excludedFolders.isEmpty()) {
            context.setExcludedFolderPatterns(PreprocessorUtils.splitForChar(this.excludedFolders, File.pathSeparatorChar));
        }
        this.fillCfgFiles(context);
        this.fillGlobalVars(context);
        return context;
    }

    public void execute() throws BuildException {
        PreprocessorContext context = null;
        try {
            context = this.generatePreprocessorContext();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
        JCPreprocessor preprocessor = new JCPreprocessor(context);
        try {
            preprocessor.execute();
        }
        catch (Exception unexpected) {
            PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
            throw new BuildException(pp == null ? unexpected.getMessage() : pp.toString(), (Throwable)(pp == null ? unexpected : pp));
        }
    }

    @Override
    public void error(@Nullable String message) {
        this.log(message, 0);
    }

    @Override
    public void info(@Nullable String message) {
        this.log(message, 2);
    }

    @Override
    public void debug(@Nullable String message) {
        this.log(message, 4);
    }

    @Override
    public void warning(@Nullable String message) {
        this.log(message, 1);
    }

    private void fillAntVariables() {
        Map<String, Value> result;
        Project theProject = this.getProject();
        if (theProject == null) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (Object key : this.getProject().getProperties().keySet()) {
                String keyStr = key.toString();
                String value = theProject.getProperty(keyStr);
                if (value == null) continue;
                result.put("ant." + keyStr.toLowerCase(Locale.ENGLISH), Value.valueOf(value));
            }
        }
        this.antVariables = result;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getVariableNames() {
        String[] result = this.antVariables == null ? new String[]{} : this.antVariables.keySet().toArray(new String[this.antVariables.size()]);
        return result;
    }

    @Override
    @Nonnull
    public Value getVariable(@Nonnull String varName, @Nonnull PreprocessorContext context) {
        if (this.antVariables == null) {
            throw context.makeException("Non-initialized ANT property map detected", null);
        }
        Value result = this.antVariables.get(varName);
        if (result == null) {
            throw context.makeException("Request for unsupported Ant property '" + varName + '\'', null);
        }
        return result;
    }

    @Override
    public void setVariable(@Nonnull String varName, @Nonnull Value value, @Nonnull PreprocessorContext context) {
        throw context.makeException("Request to change ANT property '" + varName + "'. NB! ANT properties are read only!", null);
    }

    @ImplementationNote(value="It is mutable and with default constructor for calls from ANT")
    public static class Global {
        private String name;
        private String value;

        public void setName(@Nonnull String name) {
            this.name = Assertions.assertNotNull(name);
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public void setValue(@Nonnull String value) {
            this.value = Assertions.assertNotNull(value);
        }

        @Nullable
        public String getValue() {
            return this.value;
        }
    }

    @ImplementationNote(value="It is mutable and with default constructor for calls from ANT")
    public static class CfgFile {
        private File file;

        public void setFile(@Nonnull File file) {
            this.file = Assertions.assertNotNull(file);
        }

        @Nullable
        public File getFile() {
            return this.file;
        }
    }
}

