/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.io.File;
import java.util.Locale;
import javax.annotation.Nonnull;

public class ExcludeFoldersHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/ED:";

    @Override
    @Nonnull
    public String getDescription() {
        return "subfolders in source folders to be excluded from preprocessing, ANT patterns allowed, path separator should be used for multiple items";
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        String tail;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(tail = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setExcludedFolderPatterns(PreprocessorUtils.splitForChar(tail, File.pathSeparatorChar));
            result = true;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }
}

