/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.util.Locale;
import javax.annotation.Nonnull;

public class ExcludedFileExtensionsHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/EF:";

    @Override
    @Nonnull
    public String getDescription() {
        return "set (case insensitive) file extensions which will be be excluded from preprocessing, they won't be both preprocessed and copied (by default xml)";
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        String extensions;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(extensions = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            context.setExcludedFileExtensions(extensions);
            result = true;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }
}

