/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.cmdline;

import com.igormaznitsa.jcp.cmdline.CommandLineHandler;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import java.util.Locale;
import javax.annotation.Nonnull;

public class GlobalVariableHandler
implements CommandLineHandler {
    private static final String ARG_NAME = "/P:";

    @Override
    @Nonnull
    public String getDescription() {
        return "define global variable, for instance /P:DEBUG=true (in command line use $ instead \" char)";
    }

    @Override
    public boolean processCommandLineKey(@Nonnull String key, @Nonnull PreprocessorContext context) {
        String nameAndExpression;
        boolean result = false;
        if (!key.isEmpty() && key.toUpperCase(Locale.ENGLISH).startsWith(ARG_NAME) && !(nameAndExpression = PreprocessorUtils.extractTrimmedTail(ARG_NAME, key)).isEmpty()) {
            String[] splitted = PreprocessorUtils.splitForEqualChar(nameAndExpression);
            if (splitted.length != 2) {
                throw context.makeException("Illegal expression for directive '/P:' [" + nameAndExpression + ']', null);
            }
            String value = splitted[0];
            String expression = splitted[1];
            if (context.containsGlobalVariable(value)) {
                throw context.makeException("Duplicated global definition [" + value + ']', null);
            }
            Value resultVal = Expression.evalExpression(expression, context);
            context.setGlobalVariable(value, resultVal);
            result = true;
        }
        return result;
    }

    @Override
    @Nonnull
    public String getKeyName() {
        return ARG_NAME;
    }
}

