/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.containers;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.jcp.utils.ResetablePrinter;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileInfoContainer {
    private static final Pattern DIRECTIVE_HASH_PREFIXED = Pattern.compile("^\\s*//\\s*#(.*)$");
    private static final Pattern DIRECTIVE_TWO_DOLLARS_PREFIXED = Pattern.compile("^\\s*//\\s*\\$\\$(.*)$");
    private static final Pattern DIRECTIVE_SINGLE_DOLLAR_PREFIXED = Pattern.compile("^\\s*//\\s*\\$(.*)$");
    private static final Pattern DIRECTIVE_TAIL_REMOVER = Pattern.compile("\\/\\*\\s*-\\s*\\*\\/");
    private final File sourceFile;
    private final boolean forCopyOnly;
    private boolean excludedFromPreprocessing;
    private String destFolder;
    private String destFileName;

    @Nonnull
    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean isExcludedFromPreprocessing() {
        return this.excludedFromPreprocessing;
    }

    public boolean isForCopyOnly() {
        return this.forCopyOnly;
    }

    @Nonnull
    public String getDestinationDir() {
        return this.destFolder;
    }

    @Nonnull
    public String getDestinationName() {
        return this.destFileName;
    }

    public FileInfoContainer(@Nonnull File srcFile, @Nonnull String dstFileName, boolean copyOnly) {
        Assertions.assertNotNull("The source file is null", srcFile);
        Assertions.assertNotNull("The destination file name is null", dstFileName);
        this.forCopyOnly = copyOnly;
        this.excludedFromPreprocessing = false;
        this.sourceFile = srcFile;
        int lastDirSeparator = dstFileName.lastIndexOf(47);
        if (lastDirSeparator < 0) {
            lastDirSeparator = dstFileName.lastIndexOf(92);
        }
        if (lastDirSeparator < 0) {
            this.destFolder = "." + File.separatorChar;
            this.destFileName = dstFileName;
        } else {
            this.destFolder = dstFileName.substring(0, lastDirSeparator);
            this.destFileName = dstFileName.substring(lastDirSeparator + 1);
        }
    }

    @Nonnull
    public String getDestinationFilePath() {
        String dir = this.destFolder;
        if (!dir.isEmpty() && dir.charAt(dir.length() - 1) != File.separatorChar) {
            dir = dir + File.separatorChar;
        }
        return dir + this.destFileName;
    }

    @Nonnull
    public String toString() {
        return "FileInfoContainer: source=" + PreprocessorUtils.getFilePath(this.sourceFile) + " destFolder=" + this.destFolder + " destFile=" + this.destFileName;
    }

    @Nonnull
    @MustNotContainNull
    public List<PreprocessingState.ExcludeIfInfo> processGlobalDirectives(@Nullable PreprocessingState state, @Nonnull PreprocessorContext context) throws IOException {
        PreprocessingState preprocessingState;
        block11: {
            preprocessingState = state == null ? context.produceNewPreprocessingState(this, 0) : state;
            String leftTrimmedString = null;
            try {
                block5: while (true) {
                    String nonTrimmedProcessingString = preprocessingState.nextLine();
                    Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                    if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                            processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                        }
                        nonTrimmedProcessingString = null;
                    }
                    if (nonTrimmedProcessingString == null) {
                        preprocessingState.popTextContainer();
                        if (!preprocessingState.isIncludeStackEmpty()) continue;
                        break block11;
                    }
                    leftTrimmedString = PreprocessorUtils.leftTrim(nonTrimmedProcessingString);
                    if (!this.isHashPrefixed(leftTrimmedString, context)) continue;
                    switch (this.processDirective(preprocessingState, this.extractHashPrefixedDirective(leftTrimmedString, context), context, true)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: 
                        case SHOULD_BE_COMMENTED: {
                            continue block5;
                        }
                    }
                    break;
                }
                throw new Error("Unsupported result");
            }
            catch (Exception unexpected) {
                PreprocessorException pp = PreprocessorException.extractPreprocessorException(unexpected);
                if (pp == null) {
                    throw preprocessingState.makeException("Unexpected exception detected", leftTrimmedString, unexpected);
                }
                throw pp;
            }
        }
        if (!preprocessingState.isIfStackEmpty()) {
            TextFileDataContainer lastIf = Assertions.assertNotNull(preprocessingState.peekIf());
            throw new PreprocessorException("Unclosed //#_if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
        }
        return preprocessingState.popAllExcludeIfInfoData();
    }

    private boolean isDoubleDollarPrefixed(@Nonnull String line, @Nonnull PreprocessorContext context) {
        if (context.isAllowWhitespace()) {
            return DIRECTIVE_TWO_DOLLARS_PREFIXED.matcher(line).matches();
        }
        return line.startsWith("//$$");
    }

    private boolean isSingleDollarPrefixed(@Nonnull String line, @Nonnull PreprocessorContext context) {
        if (context.isAllowWhitespace()) {
            return DIRECTIVE_SINGLE_DOLLAR_PREFIXED.matcher(line).matches();
        }
        return line.startsWith("//$");
    }

    private boolean isHashPrefixed(@Nonnull String line, @Nonnull PreprocessorContext context) {
        if (context.isAllowWhitespace()) {
            return DIRECTIVE_HASH_PREFIXED.matcher(line).matches();
        }
        return line.startsWith("//#");
    }

    @Nonnull
    private String extractHashPrefixedDirective(@Nonnull String line, @Nonnull PreprocessorContext context) {
        if (context.isAllowWhitespace()) {
            Matcher matcher = DIRECTIVE_HASH_PREFIXED.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new Error("Unexpected situation, directive is not found, contact developer! (" + line + ')');
        }
        return PreprocessorUtils.extractTail("//#", line);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private String extractDoubleDollarPrefixedDirective(@Nonnull String line, @Nonnull PreprocessorContext context) {
        String tail;
        if (context.isAllowWhitespace()) {
            Matcher matcher = DIRECTIVE_TWO_DOLLARS_PREFIXED.matcher(line);
            if (!matcher.find()) throw new Error("Unexpected situation, '//$$' directive is not found, contact developer! (" + line + ')');
            tail = matcher.group(1);
        } else {
            tail = PreprocessorUtils.extractTail("//$$", line);
        }
        if (!context.isPreserveIndent()) return tail;
        return PreprocessorUtils.replacePartByChar(line, ' ', 0, line.length() - tail.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private String extractSingleDollarPrefixedDirective(@Nonnull String line, @Nonnull PreprocessorContext context) {
        String tail;
        if (context.isAllowWhitespace()) {
            Matcher matcher = DIRECTIVE_SINGLE_DOLLAR_PREFIXED.matcher(line);
            if (!matcher.find()) throw new Error("Unexpected situation, '//$' directive is not found, contact developer! (" + line + ')');
            tail = matcher.group(1);
        } else {
            tail = PreprocessorUtils.extractTail("//$", line);
        }
        if (!context.isPreserveIndent()) return tail;
        return PreprocessorUtils.replacePartByChar(line, ' ', 0, line.length() - tail.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public PreprocessingState preprocessFile(@Nullable PreprocessingState state, @Nonnull PreprocessorContext context) throws IOException {
        if (!context.isCloned()) {
            context.clearLocalVariables();
        }
        PreprocessingState preprocessingState = state != null ? state : context.produceNewPreprocessingState(this, 1);
        String leftTrimmedString = null;
        TextFileDataContainer lastTextFileDataContainer = null;
        try {
            block6: while (true) {
                boolean usePrintLn;
                int numberOfSpacesAtTheLineBeginning;
                String rawString = preprocessingState.nextLine();
                boolean presentedNextLine = preprocessingState.hasReadLineNextLineInEnd();
                Set<PreprocessingFlag> processFlags = preprocessingState.getPreprocessingFlags();
                if (processFlags.contains((Object)PreprocessingFlag.END_PROCESSING) || processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                    if (!processFlags.contains((Object)PreprocessingFlag.ABORT_PROCESSING)) {
                        processFlags.remove((Object)PreprocessingFlag.END_PROCESSING);
                    }
                    rawString = null;
                }
                if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.END_PROCESSING)) {
                    preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.END_PROCESSING);
                    rawString = null;
                }
                if (rawString == null) {
                    lastTextFileDataContainer = preprocessingState.popTextContainer();
                    if (!preprocessingState.isIncludeStackEmpty()) continue;
                    break;
                }
                leftTrimmedString = PreprocessorUtils.leftTrim(rawString);
                String stringPrefix = leftTrimmedString.isEmpty() ? rawString : ((numberOfSpacesAtTheLineBeginning = rawString.indexOf(leftTrimmedString)) > 0 ? rawString.substring(0, numberOfSpacesAtTheLineBeginning) : "");
                String stringToBeProcessed = leftTrimmedString;
                boolean bl = usePrintLn = presentedNextLine || !context.isCareForLastNextLine();
                if (this.isHashPrefixed(stringToBeProcessed, context)) {
                    String extractedDirective = this.extractHashPrefixedDirective(stringToBeProcessed, context);
                    switch (this.processDirective(preprocessingState, extractedDirective, context, false)) {
                        case PROCESSED: 
                        case READ_NEXT_LINE: {
                            if (!context.isKeepLines()) continue block6;
                            String text = stringPrefix + "//JCP! " + extractedDirective;
                            ResetablePrinter thePrinter = Assertions.assertNotNull(preprocessingState.getPrinter());
                            if (usePrintLn) {
                                thePrinter.println(text);
                                continue block6;
                            }
                            thePrinter.print(text);
                            continue block6;
                        }
                        case SHOULD_BE_COMMENTED: {
                            String text = stringPrefix + "//JCP! " + extractedDirective;
                            ResetablePrinter thePrinter = Assertions.assertNotNull(preprocessingState.getPrinter());
                            if (usePrintLn) {
                                thePrinter.println(text);
                                continue block6;
                            }
                            thePrinter.print(text);
                            continue block6;
                        }
                    }
                    throw new Error("Unsupported result");
                }
                ResetablePrinter thePrinter = Assertions.assertNotNull(preprocessingState.getPrinter());
                if (preprocessingState.isDirectiveCanBeProcessed() && !preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.TEXT_OUTPUT_DISABLED)) {
                    String text;
                    boolean startsWithTwoDollars = this.isDoubleDollarPrefixed(leftTrimmedString, context);
                    if (!startsWithTwoDollars) {
                        stringToBeProcessed = PreprocessorUtils.processMacroses(leftTrimmedString, context);
                    }
                    if (startsWithTwoDollars) {
                        thePrinter.print(stringPrefix);
                        text = this.extractDoubleDollarPrefixedDirective(leftTrimmedString, context);
                        if (usePrintLn) {
                            thePrinter.println(text);
                            continue;
                        }
                        thePrinter.print(text);
                        continue;
                    }
                    if (this.isSingleDollarPrefixed(stringToBeProcessed, context)) {
                        thePrinter.print(stringPrefix);
                        text = this.extractSingleDollarPrefixedDirective(stringToBeProcessed, context);
                        if (usePrintLn) {
                            thePrinter.println(text);
                            continue;
                        }
                        thePrinter.print(text);
                        continue;
                    }
                    String strToOut = FileInfoContainer.findTailRemover(stringToBeProcessed, context);
                    if (preprocessingState.getPreprocessingFlags().contains((Object)PreprocessingFlag.COMMENT_NEXT_LINE)) {
                        thePrinter.print("//");
                        preprocessingState.getPreprocessingFlags().remove((Object)PreprocessingFlag.COMMENT_NEXT_LINE);
                    }
                    thePrinter.print(stringPrefix);
                    if (usePrintLn) {
                        thePrinter.println(strToOut);
                        continue;
                    }
                    thePrinter.print(strToOut);
                    continue;
                }
                if (!context.isKeepLines()) continue;
                String text = "//JCP> " + rawString;
                if (usePrintLn) {
                    thePrinter.println(text);
                    continue;
                }
                thePrinter.print(text);
            }
        }
        catch (Exception unexpected) {
            String message = unexpected.getMessage() == null ? "Unexpected exception" : unexpected.getMessage();
            throw preprocessingState.makeException(message, leftTrimmedString, unexpected);
        }
        if (!preprocessingState.isIfStackEmpty()) {
            TextFileDataContainer lastIf = Assertions.assertNotNull("'IF' stack is empty", preprocessingState.peekIf());
            throw new PreprocessorException("Unclosed //#if instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastIf.getFile(), lastIf.getNextStringIndex())}, null);
        }
        if (!preprocessingState.isWhileStackEmpty()) {
            TextFileDataContainer lastWhile = Assertions.assertNotNull("'WHILE' stack is empty", preprocessingState.peekWhile());
            throw new PreprocessorException("Unclosed //#while instruction detected", "", new FilePositionInfo[]{new FilePositionInfo(lastWhile.getFile(), lastWhile.getNextStringIndex())}, null);
        }
        if (!context.isFileOutputDisabled() && Assertions.assertNotNull(lastTextFileDataContainer).isAutoFlush()) {
            File outFile = context.createDestinationFileForPath(this.getDestinationFilePath());
            boolean wasSaved = preprocessingState.saveBuffersToFile(outFile, context.isRemoveComments());
            if (context.isVerbose()) {
                context.logForVerbose("Content was " + (wasSaved ? "saved" : "not saved") + " into file '" + outFile + "'");
            }
            if (this.sourceFile != null && context.isCopyFileAttributes()) {
                PreprocessorUtils.copyFileAttributes(this.sourceFile, outFile);
            }
        }
        return preprocessingState;
    }

    @Nonnull
    private static String findTailRemover(@Nonnull String str, @Nonnull PreprocessorContext context) {
        String result = str;
        if (context.isAllowWhitespace()) {
            Matcher matcher = DIRECTIVE_TAIL_REMOVER.matcher(str);
            if (matcher.find()) {
                result = str.substring(0, matcher.start());
            }
        } else {
            int tailRemoverStart = str.indexOf("/*-*/");
            if (tailRemoverStart >= 0) {
                result = str.substring(0, tailRemoverStart);
            }
        }
        return result;
    }

    private boolean checkDirectiveArgumentRoughly(@Nonnull AbstractDirectiveHandler directive, @Nonnull String rest) {
        boolean result;
        DirectiveArgumentType argument = directive.getArgumentType();
        String trimmedRest = rest.trim();
        switch (argument) {
            case NONE: {
                result = trimmedRest.isEmpty();
                break;
            }
            case ONOFF: {
                if (trimmedRest.isEmpty()) {
                    result = false;
                    break;
                }
                char firstChar = rest.charAt(0);
                boolean bl = result = firstChar == '+' || firstChar == '-';
                if (rest.length() <= 1) break;
                result = result && Character.isSpaceChar(rest.charAt(1));
                break;
            }
            case TAIL: {
                result = true;
                break;
            }
            default: {
                result = !trimmedRest.isEmpty() && Character.isSpaceChar(rest.charAt(0));
            }
        }
        return result;
    }

    @Nonnull
    protected AfterDirectiveProcessingBehaviour processDirective(@Nonnull PreprocessingState state, @Nonnull String directiveString, @Nonnull PreprocessorContext context, boolean firstPass) throws IOException {
        boolean executionEnabled = state.isDirectiveCanBeProcessed();
        for (AbstractDirectiveHandler handler : AbstractDirectiveHandler.DIRECTIVES) {
            String name = handler.getName();
            if (!directiveString.startsWith(name)) continue;
            if (firstPass && !handler.isGlobalPhaseAllowed() || !firstPass && !handler.isPreprocessingPhaseAllowed()) {
                return AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
            }
            boolean allowedForExecution = executionEnabled || !handler.executeOnlyWhenExecutionAllowed();
            String restOfString = PreprocessorUtils.extractTail(name, directiveString);
            if (this.checkDirectiveArgumentRoughly(handler, restOfString)) {
                if (allowedForExecution) {
                    return handler.execute(restOfString, context);
                }
                return context.isKeepLines() ? AfterDirectiveProcessingBehaviour.SHOULD_BE_COMMENTED : AfterDirectiveProcessingBehaviour.PROCESSED;
            }
            throw context.makeException("Detected bad argument for //#" + handler.getName(), null);
        }
        throw context.makeException("Unknown preprocessor directive [" + directiveString + ']', null);
    }

    public void setDestinationDir(@Nonnull String destDir) {
        Assertions.assertNotNull("String is null", destDir);
        this.destFolder = destDir;
    }

    public void setDestinationName(@Nonnull String destName) {
        Assertions.assertNotNull("String is null", destName);
        this.destFileName = destName;
    }

    public void setExcluded(boolean flag) {
        this.excludedFromPreprocessing = flag;
    }
}

