/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.containers;

import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TextFileDataContainer {
    private final String[] text;
    private final boolean fileEndedByNextLine;
    private final File file;
    private boolean autoFlush = true;
    private int nextStringIndex;

    public void disableAutoFlush() {
        this.autoFlush = false;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    @Nonnull
    @MustNotContainNull
    public String[] getText() {
        return (String[])this.text.clone();
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    public void reset() {
        this.nextStringIndex = 0;
    }

    public boolean isPresentedNextLineOnReadString() {
        return this.nextStringIndex < this.text.length || this.fileEndedByNextLine;
    }

    @Nullable
    public String nextLine() {
        if (this.nextStringIndex >= this.text.length) {
            return null;
        }
        return this.text[this.nextStringIndex++];
    }

    public void setNextStringIndex(int index) {
        if (index < 0 || index >= this.text.length) {
            throw new IndexOutOfBoundsException("String index out of bound [" + index + ']');
        }
        this.nextStringIndex = index;
    }

    public int getLastReadStringIndex() {
        return this.nextStringIndex - 1;
    }

    public int getNextStringIndex() {
        return this.nextStringIndex;
    }

    public TextFileDataContainer(@Nonnull TextFileDataContainer item, int stringIndex) {
        this(item.file, item.text, item.fileEndedByNextLine, stringIndex);
    }

    public TextFileDataContainer(@Nonnull File currentFile, @Nonnull @MustNotContainNull String[] text, boolean fileEndedByNextLine, int stringIndex) {
        Assertions.assertNotNull("File is null", currentFile);
        Assertions.assertNotNull("Text is null", text);
        this.file = currentFile;
        this.text = text;
        this.setNextStringIndex(stringIndex);
        this.fileEndedByNextLine = fileEndedByNextLine;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(@Nullable Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TextFileDataContainer) {
            TextFileDataContainer thatItem = (TextFileDataContainer)that;
            return this.file.equals(thatItem.file) && this.nextStringIndex == thatItem.nextStringIndex;
        }
        return false;
    }
}

