/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnvironmentVariableProcessor
implements SpecialVariableProcessor {
    private static final String PREFIX = "env.";
    private final Map<String, Value> environmentVars;

    public EnvironmentVariableProcessor() {
        HashMap<String, Value> env = new HashMap<String, Value>();
        Properties properties = System.getProperties();
        for (String key : properties.stringPropertyNames()) {
            env.put(PREFIX + key.toLowerCase(Locale.ENGLISH).replace(' ', '_'), Value.valueOf(properties.getProperty(key)));
        }
        this.environmentVars = Collections.unmodifiableMap(env);
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getVariableNames() {
        return this.environmentVars.keySet().toArray(new String[this.environmentVars.size()]);
    }

    @Override
    @Nullable
    public Value getVariable(@Nonnull String varName, @Nonnull PreprocessorContext context) {
        Value result = this.environmentVars.get(varName);
        if (result == null) {
            throw context.makeException("Reaing undefined environment record '" + varName + '\'', null);
        }
        return result;
    }

    @Override
    public void setVariable(@Nonnull String varName, @Nonnull Value value, @Nonnull PreprocessorContext context) {
        throw context.makeException("Illegal change of environment record '" + varName + "'. Environment records accessible only for reading!", null);
    }
}

