/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.InfoHelper;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCPSpecialVariableProcessor
implements SpecialVariableProcessor {
    public static final String VAR_DEST_DIR = "jcp.dst.dir";
    public static final String VAR_VERSION = "jcp.version";
    public static final String VAR_DEST_FILE_NAME = "jcp.dst.name";
    public static final String VAR_DEST_FULLPATH = "jcp.dst.path";
    public static final String VAR_SRC_FILE_NAME = "jcp.src.name";
    public static final String VAR_SRC_FILE_NAME2 = "__filename__";
    public static final String VAR_SRC_DIR = "jcp.src.dir";
    public static final String VAR_SRC_DIR2 = "__filefolder__";
    public static final String VAR_SRC_FULLPATH = "jcp.src.path";
    public static final String VAR_SRC_FULLPATH2 = "__file__";
    public static final String VAR_LINE = "__line__";
    public static final String VAR_DATE = "__date__";
    public static final String VAR_TIME = "__time__";
    public static final String VAR_TIMESTAMP = "__timestamp__";
    final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy");
    final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    final SimpleDateFormat timestampFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");

    @Nonnull
    @MustNotContainNull
    public static List<NameReferencePair> getReference() {
        ArrayList<NameReferencePair> result = new ArrayList<NameReferencePair>();
        result.add(new NameReferencePair(VAR_VERSION, "The Preprocessor version"));
        result.add(new NameReferencePair(VAR_SRC_FULLPATH, "Full path to the current preprocessing file, read only"));
        result.add(new NameReferencePair(VAR_SRC_FULLPATH2, "The Synonym for 'jcp.dst.path', read only"));
        result.add(new NameReferencePair(VAR_SRC_DIR, "The Current preprocessing file folder, read only"));
        result.add(new NameReferencePair(VAR_SRC_DIR2, "The Synonym for 'jcp.src.dir', read only"));
        result.add(new NameReferencePair(VAR_SRC_FILE_NAME, "The Current preprocessing file name, read only"));
        result.add(new NameReferencePair(VAR_SRC_FILE_NAME2, "The Synonym for 'jcp.src.name', read only"));
        result.add(new NameReferencePair(VAR_LINE, "The Current preprocessing line number in the current source file, read only"));
        result.add(new NameReferencePair(VAR_DEST_FULLPATH, "The Full Destination File path for the preprocessing file, read only"));
        result.add(new NameReferencePair(VAR_DEST_DIR, "The Destination File path for the preprocessing file, read only"));
        result.add(new NameReferencePair(VAR_DEST_FILE_NAME, "The Destination File name for the preprocessing file, allowed for reading and writing"));
        result.add(new NameReferencePair(VAR_TIME, "The Current time"));
        result.add(new NameReferencePair(VAR_DATE, "The Current date"));
        result.add(new NameReferencePair(VAR_TIMESTAMP, "The Timestamp of the current source file"));
        return result;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public String[] getVariableNames() {
        return new String[]{VAR_DEST_DIR, VAR_DEST_FILE_NAME, VAR_DEST_FULLPATH, VAR_SRC_DIR, VAR_SRC_DIR2, VAR_SRC_FILE_NAME, VAR_SRC_FILE_NAME2, VAR_SRC_FULLPATH, VAR_SRC_FULLPATH2, VAR_VERSION, VAR_LINE, VAR_TIME, VAR_TIMESTAMP, VAR_DATE};
    }

    @Override
    @Nullable
    public Value getVariable(@Nonnull String varName, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (VAR_DEST_DIR.equals(varName)) {
            return Value.valueOf(state.getRootFileInfo().getDestinationDir());
        }
        if (VAR_DEST_FILE_NAME.equals(varName)) {
            return Value.valueOf(state.getRootFileInfo().getDestinationName());
        }
        if (VAR_DEST_FULLPATH.equals(varName)) {
            return Value.valueOf(state.getRootFileInfo().getDestinationFilePath());
        }
        if (VAR_SRC_DIR.equals(varName) || VAR_SRC_DIR2.equals(varName)) {
            return Value.valueOf(state.getRootFileInfo().getSourceFile().getParent());
        }
        if (VAR_SRC_FILE_NAME.equals(varName) || VAR_SRC_FILE_NAME2.equals(varName)) {
            return Value.valueOf(state.getRootFileInfo().getSourceFile().getName());
        }
        if (VAR_SRC_FULLPATH.equals(varName) || VAR_SRC_FULLPATH2.equals(varName)) {
            return Value.valueOf(PreprocessorUtils.getFilePath(state.getRootFileInfo().getSourceFile()));
        }
        if (VAR_VERSION.equals(varName)) {
            return Value.valueOf(InfoHelper.getVersion());
        }
        if (VAR_TIME.equals(varName)) {
            return Value.valueOf(this.timeFormat.format(new Date()));
        }
        if (VAR_DATE.equals(varName)) {
            return Value.valueOf(this.dateFormat.format(new Date()));
        }
        if (VAR_TIMESTAMP.equals(varName)) {
            TextFileDataContainer filedata = state.peekFile();
            Value result = filedata == null ? Value.valueOf("<no file>") : Value.valueOf(this.timestampFormat.format(new Date(filedata.getFile().lastModified())));
            return result;
        }
        if (VAR_LINE.equals(varName)) {
            TextFileDataContainer currentFile = state.peekFile();
            long line = currentFile == null ? -1L : (long)(currentFile.getLastReadStringIndex() + 1);
            return Value.valueOf(line);
        }
        String text = "Attempting to read unexpected special variable [" + varName + ']';
        throw context.makeException(text, null);
    }

    @Override
    public void setVariable(@Nonnull String varName, @Nonnull Value value, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (VAR_DEST_DIR.equals(varName)) {
            if (value.getType() != ValueType.STRING) {
                throw new IllegalArgumentException("Only STRING type allowed");
            }
            state.getRootFileInfo().setDestinationDir(value.asString());
        } else if (VAR_DEST_FILE_NAME.equals(varName)) {
            if (value.getType() != ValueType.STRING) {
                throw new IllegalArgumentException("Only STRING type allowed");
            }
            state.getRootFileInfo().setDestinationName(value.asString());
        } else {
            if (VAR_DEST_FULLPATH.equals(varName) || VAR_SRC_DIR.equals(varName) || VAR_SRC_DIR2.equals(varName) || VAR_SRC_FILE_NAME.equals(varName) || VAR_SRC_FILE_NAME2.equals(varName) || VAR_SRC_FULLPATH.equals(varName) || VAR_SRC_FULLPATH2.equals(varName) || VAR_VERSION.equals(varName) || VAR_LINE.equals(varName) || VAR_TIME.equals(varName) || VAR_TIMESTAMP.equals(varName) || VAR_DATE.equals(varName)) {
                String text = "The variable '" + varName + "' can't be set directly";
                throw context.makeException(text, null);
            }
            String text = "Attempting to write unexpected special variable [" + varName + ']';
            throw context.makeException(text, null);
        }
    }

    public static final class NameReferencePair {
        private final String name;
        private final String reference;

        private NameReferencePair(@Nonnull String name, @Nonnull String reference) {
            this.name = name;
            this.reference = reference;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getReference() {
            return this.reference;
        }
    }
}

