/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.context;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.EnvironmentVariableProcessor;
import com.igormaznitsa.jcp.context.JCPSpecialVariableProcessor;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.SpecialVariableProcessor;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.extension.PreprocessorExtension;
import com.igormaznitsa.jcp.logger.PreprocessorLogger;
import com.igormaznitsa.jcp.logger.SystemOutLogger;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import hidden.jcp.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PreprocessorContext {
    public static final String DEFAULT_SOURCE_DIRECTORY = "." + File.separatorChar;
    public static final String DEFAULT_DEST_DIRECTORY = ".." + File.separatorChar + "preprocessed";
    public static final String DEFAULT_PROCESSING_EXTENSIONS = "java,txt,htm,html";
    public static final String DEFAULT_EXCLUDED_EXTENSIONS = "xml";
    public static final String DEFAULT_CHARSET = "UTF8";
    private boolean verbose = false;
    private boolean removeComments = false;
    private boolean clearDestinationDirectoryBefore = false;
    private boolean fileOutputDisabled = false;
    private boolean keepNonExecutingLines = false;
    private boolean careForLastNextLine = false;
    private boolean compareDestination = false;
    private boolean allowWhitespace = false;
    private boolean preserveIndent = false;
    private boolean copyFileAttributes = false;
    private boolean unknownVariableAsFalse = false;
    private String sourceDirectories;
    private String destinationDirectory;
    private File destinationDirectoryFile;
    private File[] sourceDirectoryFiles;
    private Set<String> processingFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitForChar("java,txt,htm,html", ',')));
    private Set<String> excludedFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitForChar("xml", ',')));
    private PreprocessorExtension preprocessorExtension;
    private String inCharacterEncoding = "UTF8";
    private String outCharacterEncoding = "UTF8";
    private final Map<String, Value> globalVarTable = new HashMap<String, Value>();
    private final Map<String, Value> localVarTable = new HashMap<String, Value>();
    private final Map<String, SpecialVariableProcessor> mapVariableNameToSpecialVarProcessor = new HashMap<String, SpecialVariableProcessor>();
    private final Map<String, Object> sharedResources = new HashMap<String, Object>();
    private PreprocessorLogger preprocessorLogger = new SystemOutLogger();
    private final List<File> configFiles = new ArrayList<File>();
    private transient PreprocessingState currentState;
    private final boolean cloned;
    private final TextFileDataContainer currentInCloneSource;
    private String[] excludedFolderPatterns = new String[0];

    public PreprocessorContext() {
        this.currentState = new PreprocessingState(this, this.inCharacterEncoding, this.outCharacterEncoding);
        this.setSourceDirectories(DEFAULT_SOURCE_DIRECTORY).setDestinationDirectory(DEFAULT_DEST_DIRECTORY);
        this.registerSpecialVariableProcessor(new JCPSpecialVariableProcessor());
        this.registerSpecialVariableProcessor(new EnvironmentVariableProcessor());
        this.cloned = false;
        this.currentInCloneSource = null;
    }

    public void setExcludedFolderPatterns(String ... patterns) {
        String[] value = (String[])Assertions.assertDoesntContainNull((Object[])Assertions.assertNotNull(patterns));
        String[] normalized = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            normalized[i] = FilenameUtils.normalize(value[i], true);
        }
        this.excludedFolderPatterns = normalized;
    }

    @Nonnull
    @MustNotContainNull
    public String[] getExcludedFolderPatterns() {
        return (String[])this.excludedFolderPatterns.clone();
    }

    public void setCareForLastNextLine(boolean flag) {
        this.careForLastNextLine = flag;
    }

    public boolean isCareForLastNextLine() {
        return this.careForLastNextLine;
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public PreprocessorContext(@Nonnull PreprocessorContext context) {
        Assertions.assertNotNull("Source context must not be null", context);
        this.verbose = context.verbose;
        this.removeComments = context.removeComments;
        this.clearDestinationDirectoryBefore = context.clearDestinationDirectoryBefore;
        this.fileOutputDisabled = context.fileOutputDisabled;
        this.keepNonExecutingLines = context.keepNonExecutingLines;
        this.allowWhitespace = context.allowWhitespace;
        this.preserveIndent = context.preserveIndent;
        this.sourceDirectories = context.sourceDirectories;
        this.destinationDirectory = context.destinationDirectory;
        this.destinationDirectoryFile = context.destinationDirectoryFile;
        this.sourceDirectoryFiles = (File[])context.sourceDirectoryFiles.clone();
        this.copyFileAttributes = context.copyFileAttributes;
        this.careForLastNextLine = context.careForLastNextLine;
        this.processingFileExtensions.clear();
        this.processingFileExtensions.addAll(context.processingFileExtensions);
        this.excludedFileExtensions.clear();
        this.excludedFileExtensions.addAll(context.excludedFileExtensions);
        this.unknownVariableAsFalse = context.unknownVariableAsFalse;
        this.preprocessorExtension = context.preprocessorExtension;
        this.inCharacterEncoding = context.inCharacterEncoding;
        this.outCharacterEncoding = context.outCharacterEncoding;
        this.compareDestination = context.compareDestination;
        this.globalVarTable.putAll(context.globalVarTable);
        this.localVarTable.putAll(context.localVarTable);
        this.excludedFolderPatterns = (String[])context.excludedFolderPatterns.clone();
        this.mapVariableNameToSpecialVarProcessor.putAll(context.mapVariableNameToSpecialVarProcessor);
        this.sharedResources.putAll(context.sharedResources);
        this.configFiles.addAll(context.configFiles);
        this.currentState = Assertions.assertNotNull(context.currentState);
        this.cloned = true;
        this.preprocessorLogger = context.preprocessorLogger;
        PreprocessingState theState = context.getPreprocessingState();
        this.currentInCloneSource = theState.peekFile();
    }

    public void setPreprocessorLogger(@Nullable PreprocessorLogger logger) {
        this.preprocessorLogger = logger;
    }

    public void registerSpecialVariableProcessor(@Nonnull SpecialVariableProcessor processor) {
        Assertions.assertNotNull("Processor is null", processor);
        for (String varName : processor.getVariableNames()) {
            Assertions.assertNotNull("A Special Var name is null", varName);
            if (this.mapVariableNameToSpecialVarProcessor.containsKey(varName)) {
                throw new IllegalStateException("There is already defined processor for " + varName);
            }
            this.mapVariableNameToSpecialVarProcessor.put(varName, processor);
        }
    }

    public void logInfo(@Nullable String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.info(text);
        }
    }

    public void logError(@Nullable String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.error(text);
        }
    }

    public void logDebug(@Nullable String text) {
        if (text != null && this.preprocessorLogger != null) {
            this.preprocessorLogger.debug(text);
        }
    }

    public void logWarning(@Nullable String text) {
        if (text != null || this.preprocessorLogger != null) {
            this.preprocessorLogger.warning(text);
        }
    }

    @Nonnull
    public PreprocessorContext setRemoveComments(boolean removingComments) {
        this.removeComments = removingComments;
        return this;
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setFileOutputDisabled(boolean flag) {
        this.fileOutputDisabled = flag;
    }

    public boolean isFileOutputDisabled() {
        return this.fileOutputDisabled;
    }

    public void setAllowWhitespace(boolean flag) {
        this.allowWhitespace = flag;
    }

    public boolean isAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setUnknownVariableAsFalse(boolean flag) {
        this.unknownVariableAsFalse = flag;
    }

    public boolean isUnknownVariableAsFalse() {
        return this.unknownVariableAsFalse;
    }

    public void setPreserveIndent(boolean flag) {
        this.preserveIndent = flag;
    }

    public boolean isPreserveIndent() {
        return this.preserveIndent;
    }

    @Nonnull
    public PreprocessorContext setSourceDirectories(@Nonnull String directories) {
        Assertions.assertNotNull("Source directory is null", directories);
        this.sourceDirectories = directories;
        this.sourceDirectoryFiles = this.getParsedSourceDirectoryAsFiles();
        return this;
    }

    public void setSharedResource(@Nonnull String name, @Nonnull Object obj) {
        Assertions.assertNotNull("Name is null", name);
        Assertions.assertNotNull("Object is null", obj);
        this.sharedResources.put(name, obj);
    }

    @Nullable
    public Object getSharedResource(@Nonnull String name) {
        Assertions.assertNotNull("Name is null", name);
        return this.sharedResources.get(name);
    }

    @Nullable
    public Object removeSharedResource(@Nonnull String name) {
        Assertions.assertNotNull("Name is null", name);
        return this.sharedResources.remove(name);
    }

    @Nonnull
    public String getSourceDirectories() {
        return this.sourceDirectories;
    }

    @Nonnull
    @MustNotContainNull
    public File[] getSourceDirectoryAsFiles() {
        return this.sourceDirectoryFiles;
    }

    @Nonnull
    @MustNotContainNull
    private File[] getParsedSourceDirectoryAsFiles() {
        String[] splitted = PreprocessorUtils.splitForChar(this.sourceDirectories, ';');
        File[] result = new File[splitted.length];
        int index = 0;
        for (String dirName : splitted) {
            File dir = new File(dirName);
            if (!dir.isDirectory()) {
                throw new IllegalStateException("Can't find a source directory [" + PreprocessorUtils.getFilePath(dir) + ']');
            }
            result[index++] = dir;
        }
        return result;
    }

    @Nonnull
    public PreprocessorContext setDestinationDirectory(@Nonnull String directory) {
        Assertions.assertNotNull("Directory is null", directory);
        this.destinationDirectory = directory;
        this.destinationDirectoryFile = new File(this.destinationDirectory);
        return this;
    }

    @Nonnull
    public File getDestinationDirectoryAsFile() {
        return this.destinationDirectoryFile;
    }

    @Nonnull
    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @Nonnull
    public PreprocessorContext setProcessingFileExtensions(@Nonnull String extensions) {
        Assertions.assertNotNull("Argument is null", extensions);
        this.processingFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitExtensionCommaList(extensions)));
        return this;
    }

    @Nonnull
    @MustNotContainNull
    public String[] getProcessingFileExtensions() {
        return this.processingFileExtensions.toArray(new String[this.processingFileExtensions.size()]);
    }

    public final boolean isFileAllowedToBeProcessed(@Nullable File file) {
        if (file == null || !file.exists() || file.isDirectory() || file.length() == 0L) {
            return false;
        }
        return this.processingFileExtensions.contains(PreprocessorUtils.getFileExtension(file));
    }

    public final boolean isFileExcludedFromProcess(@Nullable File file) {
        boolean result = file != null && file.isFile() ? this.excludedFileExtensions.contains(PreprocessorUtils.getFileExtension(file)) : false;
        return result;
    }

    @Nonnull
    public PreprocessorContext setExcludedFileExtensions(@Nonnull String extensions) {
        Assertions.assertNotNull("Argument is null", extensions);
        this.excludedFileExtensions = new HashSet<String>(Arrays.asList(PreprocessorUtils.splitExtensionCommaList(extensions)));
        return this;
    }

    @Nonnull
    @MustNotContainNull
    public String[] getExcludedFileExtensions() {
        return this.excludedFileExtensions.toArray(new String[this.excludedFileExtensions.size()]);
    }

    @Nonnull
    public PreprocessorContext setClearDestinationDirBefore(boolean flag) {
        this.clearDestinationDirectoryBefore = flag;
        return this;
    }

    public boolean doesClearDestinationDirBefore() {
        return this.clearDestinationDirectoryBefore;
    }

    @Nonnull
    public PreprocessorContext setLocalVariable(@Nonnull String name, @Nonnull Value value) {
        Assertions.assertNotNull("Variable name is null", name);
        Assertions.assertNotNull("Value is null", value);
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Not defined variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to set either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        this.localVarTable.put(normalized, value);
        return this;
    }

    @Nonnull
    public PreprocessorContext removeLocalVariable(@Nonnull String name) {
        Assertions.assertNotNull("Variable name is null", name);
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized)) {
            throw this.makeException("Attempting to remove either a global variable or a special variable as a local one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing local variable '" + normalized + "'");
        }
        this.localVarTable.remove(normalized);
        return this;
    }

    @Nonnull
    public PreprocessorContext removeGlobalVariable(@Nonnull String name) {
        Assertions.assertNotNull("Variable name is null", name);
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            throw this.makeException("Empty variable name", null);
        }
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalized)) {
            throw this.makeException("Attempting to remove a special variable as a global one [" + normalized + ']', null);
        }
        if (this.isVerbose()) {
            this.logForVerbose("Removing global variable '" + normalized + "'");
        }
        this.globalVarTable.remove(normalized);
        return this;
    }

    @Nullable
    public Value getLocalVariable(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return null;
        }
        return this.localVarTable.get(normalized);
    }

    public boolean containsLocalVariable(@Nullable String name) {
        if (name == null) {
            return false;
        }
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return false;
        }
        return this.localVarTable.containsKey(normalized);
    }

    @Nonnull
    public PreprocessorContext clearLocalVariables() {
        this.localVarTable.clear();
        return this;
    }

    @Nonnull
    public PreprocessorContext setGlobalVariable(@Nonnull String name, @Nonnull Value value) {
        Assertions.assertNotNull("Variable name is null", name);
        String normalizedName = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalizedName.isEmpty()) {
            throw this.makeException("Name is empty", null);
        }
        Assertions.assertNotNull("Value is null", value);
        if (this.mapVariableNameToSpecialVarProcessor.containsKey(normalizedName)) {
            this.mapVariableNameToSpecialVarProcessor.get(normalizedName).setVariable(normalizedName, value, this);
        } else {
            if (this.isVerbose()) {
                String valueAsStr = value.toString();
                if (this.globalVarTable.containsKey(normalizedName)) {
                    this.logForVerbose("Replacing global variable [" + normalizedName + '=' + valueAsStr + ']');
                } else {
                    this.logForVerbose("Defining new global variable [" + normalizedName + '=' + valueAsStr + ']');
                }
            }
            this.globalVarTable.put(normalizedName, value);
        }
        return this;
    }

    public boolean containsGlobalVariable(@Nullable String name) {
        if (name == null) {
            return false;
        }
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return false;
        }
        return this.mapVariableNameToSpecialVarProcessor.containsKey(normalized) || this.globalVarTable.containsKey(normalized);
    }

    @Nullable
    public Value findVariableForName(@Nullable String name, boolean enforceUnknownVarAsNull) {
        if (name == null) {
            return null;
        }
        String normalized = Assertions.assertNotNull(PreprocessorUtils.normalizeVariableName(name));
        if (normalized.isEmpty()) {
            return null;
        }
        SpecialVariableProcessor processor = this.mapVariableNameToSpecialVarProcessor.get(normalized);
        if (processor != null) {
            return processor.getVariable(normalized, this);
        }
        Value val = this.getLocalVariable(normalized);
        if (val != null) {
            return val;
        }
        Value result = this.globalVarTable.get(normalized);
        if (result == null && !enforceUnknownVarAsNull && this.unknownVariableAsFalse) {
            this.logDebug("Unknown variable '" + name + "' is replaced by FALSE!");
            result = Value.BOOLEAN_FALSE;
        }
        return result;
    }

    public boolean isGlobalVariable(@Nullable String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.globalVarTable.containsKey(normalized) || this.mapVariableNameToSpecialVarProcessor.containsKey(normalized);
        }
        return result;
    }

    public boolean isLocalVariable(@Nullable String variableName) {
        boolean result = false;
        if (variableName != null) {
            String normalized = PreprocessorUtils.normalizeVariableName(variableName);
            result = this.localVarTable.containsKey(normalized);
        }
        return result;
    }

    @Nonnull
    public PreprocessorContext setVerbose(boolean flag) {
        this.verbose = flag;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Nonnull
    public PreprocessorContext setCompareDestination(boolean flag) {
        this.compareDestination = flag;
        return this;
    }

    public boolean isCompareDestination() {
        return this.compareDestination;
    }

    @Nonnull
    public PreprocessorContext setKeepLines(boolean flag) {
        this.keepNonExecutingLines = flag;
        return this;
    }

    public boolean isKeepLines() {
        return this.keepNonExecutingLines;
    }

    public boolean isCopyFileAttributes() {
        return this.copyFileAttributes;
    }

    @Nonnull
    public PreprocessorContext setCopyFileAttributes(boolean value) {
        this.copyFileAttributes = value;
        return this;
    }

    @Nonnull
    public PreprocessorContext setPreprocessorExtension(@Nullable PreprocessorExtension extension) {
        this.preprocessorExtension = extension;
        return this;
    }

    @Nullable
    public PreprocessorExtension getPreprocessorExtension() {
        return this.preprocessorExtension;
    }

    @Nonnull
    public PreprocessorContext setInCharacterEncoding(@Nonnull String characterEncoding) {
        Assertions.assertNotNull("Value is null", characterEncoding);
        if (!Charset.isSupported(characterEncoding)) {
            throw this.makeException("Unsupported character encoding [" + characterEncoding + ']', null);
        }
        this.inCharacterEncoding = characterEncoding;
        return this;
    }

    @Nonnull
    public PreprocessorContext setOutCharacterEncoding(@Nonnull String characterEncoding) {
        if (!Charset.isSupported(characterEncoding)) {
            throw this.makeException("Unsupported character encoding [" + characterEncoding + ']', null);
        }
        this.outCharacterEncoding = characterEncoding;
        return this;
    }

    @Nonnull
    public String getInCharacterEncoding() {
        return this.inCharacterEncoding;
    }

    @Nonnull
    public String getOutCharacterEncoding() {
        return this.outCharacterEncoding;
    }

    @Nonnull
    public File createDestinationFileForPath(@Nonnull String path) {
        Assertions.assertNotNull("Path is null", path);
        if (path.isEmpty()) {
            throw this.makeException("File name is empty", null);
        }
        return new File(this.getDestinationDirectoryAsFile(), path);
    }

    @Nonnull
    public File findFileInSourceFolder(@Nonnull String path) throws IOException {
        if (path == null) {
            throw this.makeException("Path is null", null);
        }
        if (path.isEmpty()) {
            throw this.makeException("Path is empty", null);
        }
        File result = null;
        TextFileDataContainer theFile = this.currentState.peekFile();
        String parentDir = theFile == null ? null : theFile.getFile().getParent();
        File resultFile = new File(path);
        if (resultFile.isAbsolute()) {
            String normalizedPath = FilenameUtils.normalizeNoEndSeparator(resultFile.getAbsolutePath());
            for (File root : this.getSourceDirectoryAsFiles()) {
                String rootNormalizedPath = FilenameUtils.normalizeNoEndSeparator(root.getAbsolutePath()) + File.separatorChar;
                if (!normalizedPath.startsWith(rootNormalizedPath)) continue;
                result = resultFile;
                break;
            }
            if (result == null) {
                throw this.makeException("Can't find file for path '" + path + "' in preprocessing source folders, allowed usage only files in preprocessing source folders!", null);
            }
            if (!result.isFile()) {
                throw this.makeException("File '" + result + "' is either not found or not a file", null);
            }
        } else if (parentDir != null) {
            result = new File(parentDir, path);
        } else {
            ArrayList<File> setOfFoundFiles = new ArrayList<File>();
            for (File root : this.getSourceDirectoryAsFiles()) {
                File variant = new File(root, path);
                if (!variant.exists() || !variant.isFile()) continue;
                setOfFoundFiles.add(variant);
            }
            if (setOfFoundFiles.size() == 1) {
                result = (File)setOfFoundFiles.get(0);
            } else if (setOfFoundFiles.isEmpty()) {
                result = null;
            } else {
                throw this.makeException("Found several variants for path '" + path + "' in different source roots", null);
            }
            if (result == null) {
                throw this.makeException("Can't find file for path '" + path + "' among source files registered for preprocessing.", null);
            }
            if (!result.isFile()) {
                throw this.makeException("File '" + PreprocessorUtils.getFilePath(result) + "' is either not found or not a file", null);
            }
        }
        return result;
    }

    public void addConfigFile(@Nonnull File file) {
        Assertions.assertNotNull("File is null", file);
        this.configFiles.add(file);
    }

    @Nonnull
    @MustNotContainNull
    public File[] getConfigFiles() {
        return this.configFiles.toArray(new File[this.configFiles.size()]);
    }

    @Nonnull
    public PreprocessingState produceNewPreprocessingState(@Nonnull FileInfoContainer fileContainer, int phaseIndex) throws IOException {
        Assertions.assertNotNull("File container is null", fileContainer);
        if (this.verbose) {
            if (phaseIndex == 0) {
                this.logInfo("Start search global definitions in '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            } else {
                this.logInfo("Start preprocessing '" + PreprocessorUtils.getFilePath(fileContainer.getSourceFile()) + '\'');
            }
        }
        this.currentState = new PreprocessingState(this, fileContainer, this.getInCharacterEncoding(), this.getOutCharacterEncoding(), this.compareDestination);
        return this.currentState;
    }

    @Nonnull
    public PreprocessingState produceNewPreprocessingState(@Nonnull FileInfoContainer fileContainer, @Nonnull TextFileDataContainer textContainer) {
        this.currentState = new PreprocessingState(this, fileContainer, textContainer, this.getInCharacterEncoding(), this.getOutCharacterEncoding(), this.compareDestination);
        return this.currentState;
    }

    @Nonnull
    public PreprocessingState getPreprocessingState() {
        return this.currentState;
    }

    @Nonnull
    public PreprocessorException makeException(@Nonnull String text, @Nullable Throwable cause) {
        if (cause != null && cause instanceof PreprocessorException) {
            return (PreprocessorException)cause;
        }
        FilePositionInfo[] includeStack = this.currentState.makeIncludeStack();
        String sourceLine = this.currentState.getLastReadString();
        return new PreprocessorException(text, sourceLine, includeStack, cause);
    }

    public void logForVerbose(@Nonnull String str) {
        if (this.isVerbose()) {
            String stack = PreprocessorContext.makeStackView(this.currentInCloneSource, this.cloned, this.currentState.getCurrentIncludeStack());
            this.logInfo(str + (stack.isEmpty() ? (char)' ' : '\n') + stack);
        }
    }

    @Nonnull
    private static String makeStackView(@Nullable TextFileDataContainer cloneSource, boolean cloned, @Nullable @MustNotContainNull List<TextFileDataContainer> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int tab = 5;
        for (int s = 0; s < tab; ++s) {
            builder.append(' ');
        }
        builder.append('{');
        if (cloned) {
            builder.append(cloneSource == null ? "*No src info" : "*" + cloneSource.getFile().getName() + ':' + cloneSource.getNextStringIndex());
        } else {
            builder.append("File chain");
        }
        builder.append('}');
        tab += 5;
        int fileIndex = 1;
        for (int i = list.size() - 1; i >= 0; --i) {
            TextFileDataContainer cur = list.get(i);
            builder.append('\n');
            for (int s = 0; s < tab; ++s) {
                builder.append(' ');
            }
            builder.append("\u2514>");
            builder.append(fileIndex++).append(". ");
            builder.append(cur.getFile().getName()).append(':').append(cur.getLastReadStringIndex() + 1);
            tab += 3;
        }
        return builder.toString();
    }
}

