/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionParser;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ActionDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "action";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "call preprocessor user extension, arguments are comma separated";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.MULTIEXPRESSION;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        if (context.getPreprocessorExtension() != null) {
            try {
                List<ExpressionTree> args = this.parseString(string, context);
                Value[] results = new Value[args.size()];
                int index = 0;
                for (ExpressionTree expr : args) {
                    Value val = Expression.evalTree(expr, context);
                    results[index++] = val;
                }
                if (!Assertions.assertNotNull(context.getPreprocessorExtension()).processAction(context, results)) {
                    throw context.makeException("Extension can't process action ", null);
                }
            }
            catch (IOException ex) {
                throw context.makeException("Unexpected string detected [" + string + ']', ex);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Nonnull
    @MustNotContainNull
    private List<ExpressionTree> parseString(@Nonnull String str, @Nonnull PreprocessorContext context) throws IOException {
        ExpressionItem delimiter;
        ExpressionParser parser = ExpressionParser.getInstance();
        PushbackReader reader = new PushbackReader(new StringReader(str));
        ArrayList<ExpressionTree> result = new ArrayList<ExpressionTree>();
        PreprocessingState state = context.getPreprocessingState();
        FilePositionInfo[] stack = state.makeIncludeStack();
        String sources = state.getLastReadString();
        do {
            ExpressionTree tree;
            if ((delimiter = parser.readExpression(reader, tree = new ExpressionTree(stack, sources), context, false, true)) != null && ExpressionParser.SpecialItem.COMMA != delimiter) {
                throw context.makeException("Wrong argument format detected", null);
            }
            if (tree.isEmpty()) {
                if (delimiter != null) {
                    throw context.makeException("Empty argument", null);
                }
                break;
            }
            result.add(tree);
        } while (delimiter != null);
        return result;
    }
}

