/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public class BreakDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "break";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "break the current //#while...//#end loop";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = Assertions.assertNotNull(context.getPreprocessingState());
        if (state.isWhileStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "while", null);
        }
        state.getPreprocessingFlags().add(PreprocessingFlag.BREAK_COMMAND);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

