/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public class ContinueDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "continue";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "jump to current active //#while";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isWhileStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "while", null);
        }
        TextFileDataContainer whileContainer = Assertions.assertNotNull(state.peekWhile());
        state.popAllIFUntilContainerWithFile(whileContainer);
        state.popWhile();
        state.goToString(whileContainer.getNextStringIndex());
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

