/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import javax.annotation.Nonnull;

public class ElseDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "else";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "invert condition result for //#if..//#endif control structure";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isIfStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "if", null);
        }
        if (state.isAtActiveIf()) {
            if (state.getPreprocessingFlags().contains((Object)PreprocessingFlag.IF_CONDITION_FALSE)) {
                state.getPreprocessingFlags().remove((Object)PreprocessingFlag.IF_CONDITION_FALSE);
            } else {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }
}

