/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.containers.TextFileDataContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public class EndDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "end";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "end of //#while..." + this.getFullName() + " loop, do jump to the loop start";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isWhileStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "while", null);
        }
        if (state.isDirectiveCanBeProcessedIgnoreBreak()) {
            TextFileDataContainer thisWhile = Assertions.assertNotNull("'WHILE' stack is empty!", state.peekWhile());
            boolean breakIsSet = state.getPreprocessingFlags().contains((Object)PreprocessingFlag.BREAK_COMMAND);
            state.popWhile();
            if (!breakIsSet) {
                state.goToString(thisWhile.getNextStringIndex());
            }
        } else {
            state.popWhile();
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }
}

