/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import javax.annotation.Nonnull;

public class ExitIfDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "exitif";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "return to previous one in include stack if flag is true";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.BOOLEAN;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        AfterDirectiveProcessingBehaviour result = AfterDirectiveProcessingBehaviour.PROCESSED;
        Value condition = Expression.evalExpression(string, context);
        if (condition.getType() != ValueType.BOOLEAN) {
            throw context.makeException(this.getFullName() + " needs boolean argument", null);
        }
        if (((Boolean)condition.getValue()).booleanValue()) {
            state.getPreprocessingFlags().add(PreprocessingFlag.END_PROCESSING);
            result = AfterDirectiveProcessingBehaviour.READ_NEXT_LINE;
            if (context.isVerbose()) {
                context.logForVerbose("Detected " + this.getFullName() + " with active flag");
            }
        }
        return result;
    }
}

