/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

public class FlushDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "flush";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "flush text buffers to disk and clear the buffers";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (!context.isFileOutputDisabled()) {
            File outFile = context.createDestinationFileForPath(state.getRootFileInfo().getDestinationFilePath());
            try {
                if (context.isVerbose()) {
                    context.logForVerbose("Flush buffers into file '" + outFile + '\'');
                }
                boolean saved = state.saveBuffersToFile(outFile, context.isRemoveComments());
                if (context.isVerbose()) {
                    context.logForVerbose("Content was " + (saved ? "saved" : "not saved") + " into file '" + outFile + "'");
                }
                state.resetPrinters();
            }
            catch (IOException ex) {
                throw context.makeException("Can't flush text buffers", ex);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

