/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import javax.annotation.Nonnull;

public class GlobalElseDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "_else";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "invert condition result for //#_if..//#_endif control construction";
    }

    @Override
    public boolean isGlobalPhaseAllowed() {
        return true;
    }

    @Override
    public boolean isPreprocessingPhaseAllowed() {
        return false;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isIfStackEmpty()) {
            throw context.makeException("Detected " + this.getFullName() + " without " + "//#" + "_if", null);
        }
        if (state.isAtActiveIf()) {
            if (state.getPreprocessingFlags().contains((Object)PreprocessingFlag.IF_CONDITION_FALSE)) {
                state.getPreprocessingFlags().remove((Object)PreprocessingFlag.IF_CONDITION_FALSE);
            } else {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }
}

