/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.containers.PreprocessingFlag;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import javax.annotation.Nonnull;

public class IfDefinedDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "ifdefined";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "check existence of variable in the current context, it starts //#ifdefined..//#else..//#endif control structure";
    }

    protected boolean postprocessFlag(boolean variableExists) {
        return !variableExists;
    }

    @Override
    public boolean executeOnlyWhenExecutionAllowed() {
        return false;
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.VARNAME;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (state.isDirectiveCanBeProcessed()) {
            boolean variableExists;
            if (string.isEmpty()) {
                throw context.makeException(this.getFullName() + " needs variable name", null);
            }
            state.pushIf(true);
            boolean bl = variableExists = context.findVariableForName(string, true) != null;
            if (this.postprocessFlag(variableExists)) {
                state.getPreprocessingFlags().add(PreprocessingFlag.IF_CONDITION_FALSE);
            }
        } else {
            state.pushIf(false);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

