/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;

public class IncludeDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "include";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "include file and preprocess in the current file context";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        Value includingFilePath = Expression.evalExpression(string, context);
        String filePath = includingFilePath.toString();
        try {
            File thefile = context.findFileInSourceFolder(filePath);
            if (context.isVerbose()) {
                context.logForVerbose("Including file '" + thefile.getCanonicalPath() + '\'');
            }
            state.openFile(thefile);
        }
        catch (IOException ex) {
            throw context.makeException("Can't open file '" + filePath + '\'', ex);
        }
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

