/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import javax.annotation.Nonnull;

public class LocalDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "local";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        this.processLocalDefinition(string, context);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "make local definition which is visilble only in the current file context";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.SET;
    }

    private void processLocalDefinition(@Nonnull String string, @Nonnull PreprocessorContext context) {
        String[] splitted = PreprocessorUtils.splitForEqualChar(string);
        if (splitted.length != 2) {
            throw context.makeException("Can't find expression", null);
        }
        String name = splitted[0];
        Value value = Expression.evalExpression(splitted[1], context);
        context.setLocalVariable(name, value);
    }
}

