/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;

public class NoAutoFlushHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "noautoflush";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "disable autoflush for text buffers in the end of file processing";
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        PreprocessingState state = context.getPreprocessingState();
        if (context.isVerbose()) {
            context.logForVerbose("AutoFlush for file has been disabled");
        }
        Assertions.assertNotNull("The File stack is empty!", state.peekFile()).disableAutoFlush();
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

