/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.directives;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.directives.AbstractDirectiveHandler;
import com.igormaznitsa.jcp.directives.AfterDirectiveProcessingBehaviour;
import com.igormaznitsa.jcp.directives.DirectiveArgumentType;
import com.igormaznitsa.jcp.expression.Expression;
import com.igormaznitsa.jcp.expression.Value;
import javax.annotation.Nonnull;

public class OutDirDirectiveHandler
extends AbstractDirectiveHandler {
    @Override
    @Nonnull
    public String getName() {
        return "outdir";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "change result file folder (works like change 'jcp.dst.dir')";
    }

    @Override
    @Nonnull
    public DirectiveArgumentType getArgumentType() {
        return DirectiveArgumentType.STRING;
    }

    @Override
    @Nonnull
    public AfterDirectiveProcessingBehaviour execute(@Nonnull String string, @Nonnull PreprocessorContext context) {
        Value name = Expression.evalExpression(string, context);
        String nameAsString = name.toString();
        if (context.isVerbose()) {
            context.logForVerbose("Change result file folder '" + nameAsString + "'");
        }
        context.getPreprocessingState().getRootFileInfo().setDestinationDir(nameAsString);
        return AfterDirectiveProcessingBehaviour.PROCESSED;
    }
}

