/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.exceptions;

import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.io.File;
import javax.annotation.Nonnull;

public class FilePositionInfo {
    private final File file;
    private final int stringIndex;

    public FilePositionInfo(@Nonnull File file, int stringIndex) {
        Assertions.assertNotNull("File is null", file);
        this.file = file;
        this.stringIndex = stringIndex;
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    public int getStringIndex() {
        return this.stringIndex;
    }

    @Nonnull
    public String toString() {
        String filePath = PreprocessorUtils.getFilePath(this.file);
        return filePath + ':' + Integer.toString(this.stringIndex + 1);
    }
}

