/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.exceptions.FilePositionInfo;
import com.igormaznitsa.jcp.exceptions.PreprocessorException;
import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ExpressionTree;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.expression.operators.AbstractOperator;
import com.igormaznitsa.jcp.expression.operators.OperatorSUB;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import com.igormaznitsa.meta.common.utils.Assertions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpressionTreeElement {
    private static final OperatorSUB OPERATOR_SUB = AbstractOperator.findForClass(OperatorSUB.class);
    public static final ExpressionTreeElement EMPTY_SLOT = new ExpressionTreeElement();
    private static final ExpressionTreeElement[] EMPTY = new ExpressionTreeElement[0];
    private ExpressionItem savedItem;
    private ExpressionTreeElement[] childElements;
    private ExpressionTreeElement parentTreeElement;
    private int priority;
    private int nextChildSlot = 0;
    private final String sourceString;
    private final FilePositionInfo[] includeStack;

    private ExpressionTreeElement() {
        this.sourceString = "";
        this.includeStack = new FilePositionInfo[0];
    }

    public boolean isEmptySlot() {
        return EMPTY_SLOT == this;
    }

    ExpressionTreeElement(@Nonnull ExpressionItem item, @Nonnull @MustNotContainNull FilePositionInfo[] callStack, @Nullable String sourceString) {
        this.sourceString = sourceString;
        this.includeStack = callStack;
        if (item == null) {
            throw new PreprocessorException("[Expression]The item is null", this.sourceString, this.includeStack, null);
        }
        int arity = 0;
        if (item.getExpressionItemType() == ExpressionItemType.OPERATOR) {
            arity = ((AbstractOperator)item).getArity();
        } else if (item.getExpressionItemType() == ExpressionItemType.FUNCTION) {
            arity = ((AbstractFunction)item).getArity();
        }
        this.priority = item.getExpressionItemPriority().getPriority();
        this.savedItem = item;
        this.childElements = arity == 0 ? EMPTY : new ExpressionTreeElement[arity];
        Arrays.fill(this.childElements, EMPTY_SLOT);
    }

    private void assertNotEmptySlot() {
        if (this.isEmptySlot()) {
            throw new UnsupportedOperationException("Unsupported operation for empty slot");
        }
    }

    void makeMaxPriority() {
        this.priority = ExpressionItemPriority.VALUE.getPriority();
    }

    @Nonnull
    public ExpressionItem getItem() {
        return this.savedItem;
    }

    public int getArity() {
        return this.childElements.length;
    }

    @Nullable
    public ExpressionTreeElement getParent() {
        return this.parentTreeElement;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public ExpressionTreeElement addSubTree(@Nonnull ExpressionTree tree) {
        this.assertNotEmptySlot();
        ExpressionTreeElement root = tree.getRoot();
        if (!root.isEmptySlot()) {
            root.makeMaxPriority();
            this.addElementToNextFreeSlot(root);
        }
        return this;
    }

    public boolean replaceElement(@Nonnull ExpressionTreeElement oldOne, @Nonnull ExpressionTreeElement newOne) {
        this.assertNotEmptySlot();
        if (oldOne == null) {
            throw new PreprocessorException("[Expression]The old element is null", this.sourceString, this.includeStack, null);
        }
        if (newOne == null) {
            throw new PreprocessorException("[Expression]The new element is null", this.sourceString, this.includeStack, null);
        }
        boolean result = false;
        ExpressionTreeElement[] children = this.childElements;
        int len = children.length;
        for (int i = 0; i < len; ++i) {
            if (children[i] != oldOne) continue;
            children[i] = newOne;
            newOne.parentTreeElement = this;
            result = true;
            break;
        }
        return result;
    }

    @Nonnull
    public ExpressionTreeElement getChildForIndex(int index) {
        this.assertNotEmptySlot();
        return this.childElements[index];
    }

    @Nullable
    public ExpressionTreeElement addTreeElement(@Nonnull ExpressionTreeElement element) {
        this.assertNotEmptySlot();
        Assertions.assertNotNull("The element is null", element);
        int newElementPriority = element.getPriority();
        ExpressionTreeElement result = this;
        ExpressionTreeElement parentTreeElement = this.parentTreeElement;
        int currentPriority = this.getPriority();
        if (newElementPriority < currentPriority) {
            if (parentTreeElement == null) {
                element.addTreeElement(this);
                result = element;
            } else {
                result = parentTreeElement.addTreeElement(element);
            }
        } else if (newElementPriority == currentPriority) {
            if (parentTreeElement != null) {
                parentTreeElement.replaceElement(this, element);
            }
            if (element.nextChildSlot >= element.childElements.length) {
                throw new PreprocessorException("[Expression]Can't process expression item, may be wrong number of arguments", this.sourceString, this.includeStack, null);
            }
            element.childElements[element.nextChildSlot] = this;
            ++element.nextChildSlot;
            this.parentTreeElement = element;
            result = element;
        } else if (this.isFull()) {
            int lastElementIndex = this.getArity() - 1;
            ExpressionTreeElement lastElement = this.childElements[lastElementIndex];
            if (lastElement.getPriority() > newElementPriority) {
                element.addElementToNextFreeSlot(lastElement);
                this.childElements[lastElementIndex] = element;
                element.parentTreeElement = this;
                result = element;
            }
        } else {
            this.addElementToNextFreeSlot(element);
            result = element;
        }
        return result;
    }

    public boolean isFull() {
        return this.nextChildSlot >= this.childElements.length;
    }

    public void fillArguments(@Nonnull @MustNotContainNull List<ExpressionTree> arguments) {
        this.assertNotEmptySlot();
        if (arguments == null) {
            throw new PreprocessorException("[Expression]Argument list is null", this.sourceString, this.includeStack, null);
        }
        if (this.childElements.length != arguments.size()) {
            throw new PreprocessorException("Wrong argument list size", this.sourceString, this.includeStack, null);
        }
        int i = 0;
        for (ExpressionTree arg : arguments) {
            if (arg == null) {
                throw new PreprocessorException("[Expression]Argument [" + (i + 1) + "] is null", this.sourceString, this.includeStack, null);
            }
            if (!this.childElements[i].isEmptySlot()) {
                throw new PreprocessorException("[Expression]Non-empty slot detected, it is possible that there is a program error, contact a developer please", this.sourceString, this.includeStack, null);
            }
            ExpressionTreeElement root = arg.getRoot();
            if (root.isEmptySlot()) {
                throw new PreprocessorException("[Expression]Empty argument [" + (i + 1) + "] detected", this.sourceString, this.includeStack, null);
            }
            this.childElements[i] = root;
            root.parentTreeElement = this;
            ++i;
        }
    }

    private void addElementToNextFreeSlot(@Nonnull ExpressionTreeElement element) {
        if (element == null) {
            throw new PreprocessorException("[Expression]Element is null", this.sourceString, this.includeStack, null);
        }
        if (this.childElements.length == 0) {
            throw new PreprocessorException("[Expression]Unexpected element, may be unknown function [" + this.savedItem.toString() + ']', this.sourceString, this.includeStack, null);
        }
        if (this.isFull()) {
            throw new PreprocessorException("[Expression]There is not any possibility to add new argument [" + this.savedItem.toString() + ']', this.sourceString, this.includeStack, null);
        }
        this.childElements[this.nextChildSlot++] = element;
        element.parentTreeElement = this;
    }

    public void postProcess() {
        if (!this.isEmptySlot()) {
            block0 : switch (this.savedItem.getExpressionItemType()) {
                case OPERATOR: {
                    if (this.savedItem == OPERATOR_SUB) {
                        if (!this.childElements[0].isEmptySlot() && this.childElements[1].isEmptySlot()) {
                            ExpressionTreeElement left = this.childElements[0];
                            ExpressionItem item = left.getItem();
                            if (item.getExpressionItemType() != ExpressionItemType.VALUE) break;
                            Value val = (Value)item;
                            switch (val.getType()) {
                                case INT: {
                                    this.childElements = EMPTY;
                                    this.savedItem = Value.valueOf(0L - val.asLong());
                                    this.makeMaxPriority();
                                    break block0;
                                }
                                case FLOAT: {
                                    this.childElements = EMPTY;
                                    this.savedItem = Value.valueOf(Float.valueOf(0.0f - val.asFloat().floatValue()));
                                    this.makeMaxPriority();
                                    break block0;
                                }
                            }
                            if (left.isEmptySlot()) break;
                            left.postProcess();
                            break;
                        }
                        for (ExpressionTreeElement element : this.childElements) {
                            if (element.isEmptySlot()) continue;
                            element.postProcess();
                        }
                    } else {
                        for (ExpressionTreeElement element : this.childElements) {
                            if (element.isEmptySlot()) continue;
                            element.postProcess();
                        }
                    }
                    break;
                }
                case FUNCTION: {
                    for (ExpressionTreeElement element : this.childElements) {
                        if (element.isEmptySlot()) continue;
                        element.postProcess();
                    }
                    break;
                }
            }
        }
    }
}

