/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression;

import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.common.utils.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Value
implements ExpressionItem {
    public static final Value BOOLEAN_TRUE = new Value(Boolean.TRUE);
    public static final Value BOOLEAN_FALSE = new Value(Boolean.FALSE);
    public static final Value INT_ZERO = new Value(0L);
    public static final Value INT_ONE = new Value(1L);
    public static final Value INT_TWO = new Value(2L);
    public static final Value INT_THREE = new Value(3L);
    public static final Value INT_FOUR = new Value(4L);
    public static final Value INT_FIVE = new Value(5L);
    private final Object value;
    private final ValueType type;

    @Nonnull
    public ValueType getType() {
        return this.type;
    }

    @Nonnull
    public Object getValue() {
        return this.value;
    }

    private Value(@Nullable String val) {
        this.value = val == null ? "null" : val;
        this.type = ValueType.STRING;
    }

    private Value(@Nonnull Long val) {
        this.value = val;
        this.type = ValueType.INT;
    }

    private Value(@Nonnull Float val) {
        this.value = val;
        this.type = ValueType.FLOAT;
    }

    private Value(@Nonnull Boolean val) {
        this.value = val;
        this.type = ValueType.BOOLEAN;
    }

    @Nonnull
    public static Value valueOf(@Nonnull Long val) {
        return new Value(val);
    }

    @Nonnull
    public static Value valueOf(@Nonnull Boolean val) {
        return val != false ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    @Nonnull
    public static Value valueOf(@Nonnull Float val) {
        return new Value(val);
    }

    @Nonnull
    public static Value valueOf(@Nonnull String val) {
        return new Value(val);
    }

    @Nonnull
    public Long asLong() {
        if (this.type != ValueType.INT) {
            throw new IllegalStateException("Value is not integer");
        }
        return (Long)this.value;
    }

    @Nonnull
    public Float asFloat() {
        if (this.type != ValueType.FLOAT) {
            throw new IllegalStateException("Value is not float");
        }
        return (Float)this.value;
    }

    @Nonnull
    public String asString() {
        if (this.type != ValueType.STRING) {
            throw new IllegalStateException("Value is not string");
        }
        return (String)this.value;
    }

    @Nonnull
    public Boolean asBoolean() {
        if (this.type != ValueType.BOOLEAN) {
            throw new IllegalStateException("Value is not boolean");
        }
        return (Boolean)this.value;
    }

    @Nonnull
    public static Value recognizeRawString(@Nonnull String str) {
        Assertions.assertNotNull("Parameter is null", str);
        if ("true".equals(str)) {
            return BOOLEAN_TRUE;
        }
        if ("false".equals(str)) {
            return BOOLEAN_FALSE;
        }
        try {
            return new Value(Long.parseLong(str));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Value(Float.valueOf(Float.parseFloat(str)));
            }
            catch (NumberFormatException numberFormatException2) {
                return new Value(str);
            }
        }
    }

    @Nonnull
    public static Value recognizeOf(@Nonnull String str) {
        Value result;
        ValueType type = Value.recognizeType(str);
        switch (type) {
            case BOOLEAN: {
                result = "true".equalsIgnoreCase(str) ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                break;
            }
            case INT: {
                result = new Value((Long)Value.getValue(str, ValueType.INT));
                break;
            }
            case FLOAT: {
                result = new Value((Float)Value.getValue(str, ValueType.FLOAT));
                break;
            }
            case STRING: {
                result = new Value((String)Value.getValue(str, ValueType.STRING));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value [" + str + ']');
            }
        }
        return result;
    }

    @Nullable
    public static Object getValue(@Nonnull String value, @Nonnull ValueType type) {
        try {
            switch (type) {
                case STRING: {
                    return value.substring(1, value.length() - 1);
                }
                case BOOLEAN: {
                    return value.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                case INT: {
                    if (value.length() > 2 && value.charAt(0) == '0' && (value.charAt(1) == 'x' || value.charAt(1) == 'X')) {
                        return Long.valueOf(PreprocessorUtils.extractTail("0x", value), 16);
                    }
                    return Long.valueOf(value);
                }
                case FLOAT: {
                    return Float.valueOf(value);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    public static ValueType recognizeType(@Nonnull String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return ValueType.BOOLEAN;
        }
        if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return ValueType.STRING;
        }
        try {
            if (value.indexOf(46) >= 0) {
                Float.parseFloat(value);
                return ValueType.FLOAT;
            }
            if (value.startsWith("0x")) {
                Long.parseLong(PreprocessorUtils.extractTail("0x", value), 16);
            } else {
                Long.parseLong(value, 10);
            }
            return ValueType.INT;
        }
        catch (NumberFormatException e) {
            return ValueType.UNKNOWN;
        }
    }

    @Nonnull
    public String toStringDetail() {
        switch (this.type) {
            case BOOLEAN: {
                return "Boolean : " + (Boolean)this.value;
            }
            case INT: {
                return "Integer : " + (Long)this.value;
            }
            case UNKNOWN: {
                return "Unknown : -";
            }
            case FLOAT: {
                return "Float : " + (Float)this.value;
            }
            case STRING: {
                return "String : " + (String)this.value;
            }
        }
        return "!!! ERROR , UNSUPPORTED TYPE [" + (Object)((Object)this.type) + "]";
    }

    @Nonnull
    public String toString() {
        switch (this.type) {
            case BOOLEAN: {
                return this.asBoolean().toString();
            }
            case INT: {
                return this.asLong().toString();
            }
            case UNKNOWN: {
                return "<UNKNOWN>";
            }
            case FLOAT: {
                return this.asFloat().toString();
            }
            case STRING: {
                return this.asString();
            }
        }
        return "!!! ERROR , UNSUPPORTED TYPE [" + (Object)((Object)this.type) + "]";
    }

    @Override
    @Nonnull
    public ExpressionItemType getExpressionItemType() {
        return ExpressionItemType.VALUE;
    }

    @Override
    @Nonnull
    public ExpressionItemPriority getExpressionItemPriority() {
        return ExpressionItemPriority.VALUE;
    }

    public boolean equals(@Nullable Object var) {
        if (this == var) {
            return true;
        }
        if (var instanceof Value) {
            Value thatValue = (Value)var;
            return this.type == thatValue.type && this.value.equals(thatValue.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

