/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.expression.ExpressionItem;
import com.igormaznitsa.jcp.expression.ExpressionItemPriority;
import com.igormaznitsa.jcp.expression.ExpressionItemType;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.FunctionABS;
import com.igormaznitsa.jcp.expression.functions.FunctionBINFILE;
import com.igormaznitsa.jcp.expression.functions.FunctionEVALFILE;
import com.igormaznitsa.jcp.expression.functions.FunctionIS;
import com.igormaznitsa.jcp.expression.functions.FunctionISSUBSTR;
import com.igormaznitsa.jcp.expression.functions.FunctionROUND;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2CSV;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2GO;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2INT;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JAVA;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JS;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2JSON;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2WEB;
import com.igormaznitsa.jcp.expression.functions.FunctionSTR2XML;
import com.igormaznitsa.jcp.expression.functions.FunctionSTRLEN;
import com.igormaznitsa.jcp.expression.functions.FunctionTRIMLINES;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_ATTR;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_GET;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_LIST;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_NAME;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_OPEN;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_ROOT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_SIZE;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_TEXT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_XELEMENT;
import com.igormaznitsa.jcp.expression.functions.xml.FunctionXML_XLIST;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractFunction
implements ExpressionItem {
    public static final String EXECUTION_PREFIX = "execute";
    public static final AbstractFunction[] ALL_FUNCTIONS = new AbstractFunction[]{new FunctionABS(), new FunctionROUND(), new FunctionSTR2INT(), new FunctionSTR2WEB(), new FunctionSTR2CSV(), new FunctionSTR2JS(), new FunctionSTR2JSON(), new FunctionSTR2XML(), new FunctionSTR2JAVA(), new FunctionSTR2GO(), new FunctionTRIMLINES(), new FunctionSTRLEN(), new FunctionISSUBSTR(), new FunctionIS(), new FunctionEVALFILE(), new FunctionBINFILE(), new FunctionXML_GET(), new FunctionXML_SIZE(), new FunctionXML_ATTR(), new FunctionXML_ROOT(), new FunctionXML_NAME(), new FunctionXML_LIST(), new FunctionXML_TEXT(), new FunctionXML_OPEN(), new FunctionXML_XLIST(), new FunctionXML_XELEMENT()};
    public static final Map<String, AbstractFunction> FUNCTION_NAME_MAP;
    protected static final AtomicLong UID_COUNTER;

    @Nullable
    public static <E extends AbstractFunction> E findForClass(@Nonnull Class<E> functionClass) {
        AbstractFunction result = null;
        for (AbstractFunction function : ALL_FUNCTIONS) {
            if (function.getClass() != functionClass) continue;
            result = (AbstractFunction)functionClass.cast(function);
            break;
        }
        return (E)result;
    }

    @Nullable
    public static AbstractFunction findForName(@Nonnull String str) {
        return FUNCTION_NAME_MAP.get(str);
    }

    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract String getReference();

    public abstract int getArity();

    @Nonnull
    @MustNotContainNull
    public abstract ValueType[][] getAllowedArgumentTypes();

    @Nonnull
    public abstract ValueType getResultType();

    @Override
    @Nonnull
    public ExpressionItemPriority getExpressionItemPriority() {
        return ExpressionItemPriority.FUNCTION;
    }

    @Override
    @Nonnull
    public ExpressionItemType getExpressionItemType() {
        return ExpressionItemType.FUNCTION;
    }

    @Nullable
    public String toString() {
        return "FUNCTION: " + this.getName();
    }

    static {
        HashMap<String, AbstractFunction> map = new HashMap<String, AbstractFunction>();
        for (AbstractFunction f : ALL_FUNCTIONS) {
            if (map.put(f.getName(), f) == null) continue;
            throw new Error("Detected unexpected overriden function : " + f.getName());
        }
        FUNCTION_NAME_MAP = Collections.unmodifiableMap(map);
        UID_COUNTER = new AtomicLong(1L);
    }
}

