/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.containers.FileInfoContainer;
import com.igormaznitsa.jcp.context.PreprocessingState;
import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import hidden.jcp.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.annotation.Nonnull;

public class FunctionEVALFILE
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING}};

    @Override
    @Nonnull
    public String getName() {
        return "evalfile";
    }

    @Override
    @Nonnull
    public String getReference() {
        return "load and preprocess file and return text result as string";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }

    @Nonnull
    private PreprocessorContext prepareContext(@Nonnull PreprocessorContext base) {
        PreprocessorContext result = new PreprocessorContext(base);
        result.setFileOutputDisabled(true);
        result.setKeepLines(false);
        result.setClearDestinationDirBefore(false);
        result.setRemoveComments(true);
        result.setCareForLastNextLine(true);
        return result;
    }

    @Nonnull
    public Value executeStr(@Nonnull PreprocessorContext context, @Nonnull Value strfilePath) {
        File theFile;
        String filePath = strfilePath.asString();
        try {
            theFile = context.findFileInSourceFolder(filePath);
        }
        catch (IOException ex) {
            throw context.makeException("Can't get get source file '" + filePath + '\'', null);
        }
        if (context.isVerbose()) {
            context.logForVerbose("Eval file '" + theFile + '\'');
        }
        try {
            FileInfoContainer fileContainer = new FileInfoContainer(theFile, theFile.getName(), false);
            PreprocessingState state = fileContainer.preprocessFile(null, this.prepareContext(context));
            StringWriter strWriter = new StringWriter(1024);
            state.writePrinterBuffers(strWriter);
            IOUtils.closeQuietly(strWriter);
            return Value.valueOf(strWriter.toString());
        }
        catch (Exception ex) {
            throw context.makeException("Unexpected exception", ex);
        }
    }
}

