/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jcp.expression.functions;

import com.igormaznitsa.jcp.context.PreprocessorContext;
import com.igormaznitsa.jcp.expression.Value;
import com.igormaznitsa.jcp.expression.ValueType;
import com.igormaznitsa.jcp.expression.functions.AbstractFunction;
import com.igormaznitsa.jcp.utils.PreprocessorUtils;
import com.igormaznitsa.meta.annotation.MustNotContainNull;
import javax.annotation.Nonnull;

public final class FunctionSTR2GO
extends AbstractFunction {
    private static final ValueType[][] ARG_TYPES = new ValueType[][]{{ValueType.STRING, ValueType.BOOLEAN}};

    @Override
    @Nonnull
    public String getName() {
        return "str2go";
    }

    @Nonnull
    public Value executeStrBool(@Nonnull PreprocessorContext context, @Nonnull Value source, @Nonnull Value splitAndQuoteLines) {
        if (splitAndQuoteLines.asBoolean().booleanValue()) {
            boolean endsWithNextLine = source.asString().endsWith("\n");
            String[] splitted = PreprocessorUtils.splitForCharAndHoldEmptyLine(source.asString(), '\n');
            StringBuilder result = new StringBuilder(source.asString().length() * 2);
            String nextLineChars = PreprocessorUtils.getNextLineCodes();
            int index = 0;
            for (String s : splitted) {
                boolean last;
                boolean bl = last = ++index == splitted.length;
                if (result.length() > 0) {
                    result.append(nextLineChars).append('+');
                }
                result.append('\"').append(FunctionSTR2GO.escapeGo(s));
                if (last) {
                    result.append(endsWithNextLine ? "\\n\"" : "\"");
                    continue;
                }
                result.append("\\n\"");
            }
            return Value.valueOf(result.toString());
        }
        return Value.valueOf(FunctionSTR2GO.escapeGo(source.asString()));
    }

    @Nonnull
    private static String toUnicode(char c) {
        StringBuilder result = new StringBuilder(4);
        String hex = Integer.toHexString(c);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            result.append('0');
        }
        result.append(hex);
        return result.toString();
    }

    @Nonnull
    private static String escapeGo(@Nonnull String value) {
        StringBuilder result = new StringBuilder();
        block13: for (char c : value.toCharArray()) {
            switch (c) {
                case '\u0007': {
                    result.append("\\a");
                    continue block13;
                }
                case '\u000b': {
                    result.append("\\v");
                    continue block13;
                }
                case '\b': {
                    result.append("\\b");
                    continue block13;
                }
                case '\f': {
                    result.append("\\f");
                    continue block13;
                }
                case '\n': {
                    result.append("\\n");
                    continue block13;
                }
                case '\r': {
                    result.append("\\r");
                    continue block13;
                }
                case '\t': {
                    result.append("\\t");
                    continue block13;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block13;
                }
                case '\'': {
                    result.append("\\'");
                    continue block13;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block13;
                }
                case ' ': {
                    result.append(" ");
                    continue block13;
                }
                default: {
                    if (Character.isISOControl(c) || Character.isWhitespace(c) || c > '\u00ff') {
                        result.append("\\u").append(FunctionSTR2GO.toUnicode(c));
                        continue block13;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    @Nonnull
    @MustNotContainNull
    public ValueType[][] getAllowedArgumentTypes() {
        return ARG_TYPES;
    }

    @Override
    @Nonnull
    public String getReference() {
        return "escapes a string to be compatible with  GoLang";
    }

    @Override
    @Nonnull
    public ValueType getResultType() {
        return ValueType.STRING;
    }
}

